/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.search.spi.LuceneMigrationUtils;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.BooleanPredicateClausesStep;
import org.hibernate.search.engine.search.predicate.dsl.BooleanPredicateOptionsCollector;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.PredicateScoreStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.query.dsl.Termination;
import org.hibernate.search.query.dsl.impl.FieldContext;
import org.hibernate.search.query.dsl.impl.FieldsContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;

abstract class AbstractConnectedMultiFieldsQueryBuilder<T, F extends PredicateScoreStep<? extends F> & PredicateFinalStep>
implements Termination<T> {
    protected final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final FieldsContext fieldsContext;

    public AbstractConnectedMultiFieldsQueryBuilder(QueryBuildingContext queryContext, QueryCustomizer queryCustomizer, FieldsContext fieldsContext) {
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.fieldsContext = fieldsContext;
    }

    @Override
    public final Query createQuery() {
        return LuceneMigrationUtils.toLuceneQuery((SearchPredicate)this.createPredicate());
    }

    private SearchPredicate createPredicate() {
        SearchPredicateFactory factory = this.queryContext.getScope().predicate();
        if (this.fieldsContext.size() == 1) {
            F finalStep = this.createPredicate(factory, this.fieldsContext.getFirst());
            this.queryCustomizer.applyScoreOptions((PredicateScoreStep<?>)finalStep);
            SearchPredicate predicate = ((PredicateFinalStep)finalStep).toPredicate();
            return this.queryCustomizer.applyFilter(factory, predicate);
        }
        BooleanPredicateClausesStep boolStep = (BooleanPredicateClausesStep)factory.bool().with(b -> {
            for (FieldContext fieldContext : this.fieldsContext) {
                b.should((PredicateFinalStep)this.createPredicate(factory, fieldContext));
            }
            this.queryCustomizer.applyFilter(factory, (BooleanPredicateOptionsCollector<?, ?>)b);
        });
        this.queryCustomizer.applyScoreOptions((PredicateScoreStep<?>)boolStep);
        return boolStep.toPredicate();
    }

    protected abstract F createPredicate(SearchPredicateFactory var1, FieldContext var2);
}

