/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.hibernate.search.query.dsl.RangeMatchingContext;
import org.hibernate.search.query.dsl.RangeTerminationExcludable;
import org.hibernate.search.query.dsl.impl.ConnectedMultiFieldsRangeQueryBuilder;
import org.hibernate.search.query.dsl.impl.FieldsContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.RangeQueryContext;

public class ConnectedRangeMatchingContext
implements RangeMatchingContext {
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final RangeQueryContext rangeContext;
    private final FieldsContext fieldsContext;

    public ConnectedRangeMatchingContext(String fieldName, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.rangeContext = new RangeQueryContext();
        this.fieldsContext = new FieldsContext(new String[]{fieldName}, queryContext);
    }

    @Override
    public RangeMatchingContext andField(String field) {
        this.fieldsContext.add(field);
        return this;
    }

    @Override
    public <T> RangeMatchingContext.FromRangeContext<T> from(T from) {
        this.rangeContext.setFrom(from);
        return new ConnectedFromRangeContext(this);
    }

    @Override
    public RangeTerminationExcludable below(Object below) {
        this.rangeContext.setTo(below);
        return new ConnectedMultiFieldsRangeQueryBuilder(this.queryContext, this.queryCustomizer, this.fieldsContext, this.rangeContext);
    }

    @Override
    public RangeTerminationExcludable above(Object above) {
        this.rangeContext.setFrom(above);
        return new ConnectedMultiFieldsRangeQueryBuilder(this.queryContext, this.queryCustomizer, this.fieldsContext, this.rangeContext);
    }

    @Override
    public RangeMatchingContext boostedTo(float boost) {
        this.fieldsContext.boostedTo(boost);
        return this;
    }

    @Override
    public RangeMatchingContext ignoreAnalyzer() {
        this.fieldsContext.ignoreAnalyzer();
        return this;
    }

    @Override
    public RangeMatchingContext ignoreFieldBridge() {
        this.fieldsContext.ignoreFieldBridge();
        return this;
    }

    static class ConnectedFromRangeContext<T>
    implements RangeMatchingContext.FromRangeContext<T> {
        private final ConnectedRangeMatchingContext mother;

        ConnectedFromRangeContext(ConnectedRangeMatchingContext mother) {
            this.mother = mother;
        }

        @Override
        public RangeTerminationExcludable to(T to) {
            this.mother.rangeContext.setTo(to);
            return new ConnectedMultiFieldsRangeQueryBuilder(this.mother.queryContext, this.mother.queryCustomizer, this.mother.fieldsContext, this.mother.rangeContext);
        }

        @Override
        public RangeMatchingContext.FromRangeContext<T> excludeLimit() {
            this.mother.rangeContext.setExcludeFrom(true);
            return this;
        }
    }
}

