/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.io.Serializable;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionDelegatorBaseImpl;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.FullTextSharedSessionBuilder;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.engine.search.query.dsl.SearchQuerySelectStep;
import org.hibernate.search.hcore.util.impl.ContextHelper;
import org.hibernate.search.impl.FullTextSharedSessionBuilderDelegator;
import org.hibernate.search.impl.SearchFactoryImpl;
import org.hibernate.search.impl.V5MigrationOrmSearchIntegratorAdapter;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.mapper.orm.Search;
import org.hibernate.search.mapper.orm.search.loading.dsl.SearchLoadingOptionsStep;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.hibernate.search.massindexing.impl.V5MigrationMassIndexerAdapter;
import org.hibernate.search.query.engine.spi.V5MigrationSearchSession;
import org.hibernate.search.query.hibernate.impl.FullTextQueryImpl;
import org.hibernate.search.scope.impl.V5MigrationOrmSearchScopeAdapter;
import org.hibernate.search.scope.spi.V5MigrationSearchScope;

final class FullTextSessionImpl
extends SessionDelegatorBaseImpl
implements FullTextSession,
SessionImplementor,
V5MigrationSearchSession<SearchLoadingOptionsStep> {
    private transient V5MigrationOrmSearchIntegratorAdapter searchIntegrator;
    private transient SearchFactory searchFactoryAPI;

    public FullTextSessionImpl(Session session) {
        super((SessionImplementor)session);
    }

    @Override
    public FullTextQuery createFullTextQuery(Query luceneQuery, Class<?> ... entities) {
        return new FullTextQueryImpl(luceneQuery, this.delegate, this.getSearchIntegrator(), this, entities);
    }

    @Override
    public <T> void purgeAll(Class<T> entityType) {
        this.searchSession().workspace(new Class[]{entityType}).purge();
    }

    @Override
    public void flushToIndexes() {
        this.searchSession().indexingPlan().execute();
    }

    @Override
    public <T> void purge(Class<T> entityType, Serializable id) {
        if (entityType == null) {
            return;
        }
        if (id == null) {
            this.purgeAll(entityType);
        } else {
            this.searchSession().indexingPlan().purge(entityType, (Object)id, null);
        }
    }

    @Override
    public <T> void index(T entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity to index should not be null");
        }
        this.searchSession().indexingPlan().addOrUpdate(entity);
    }

    @Override
    public MassIndexer createIndexer(Class<?> ... types) {
        return new V5MigrationMassIndexerAdapter(types == null || types.length == 0 ? this.searchSession().massIndexer(new Class[]{Object.class}) : this.searchSession().massIndexer((Class[])types));
    }

    @Override
    public SearchFactory getSearchFactory() {
        if (this.searchFactoryAPI == null) {
            this.searchFactoryAPI = new SearchFactoryImpl(this.getSearchIntegrator());
        }
        return this.searchFactoryAPI;
    }

    private V5MigrationOrmSearchIntegratorAdapter getSearchIntegrator() {
        if (this.searchIntegrator == null) {
            this.searchIntegrator = ContextHelper.getSearchIntegrator((Session)this.delegate);
        }
        return this.searchIntegrator;
    }

    @Override
    public FullTextSharedSessionBuilder sessionWithOptions() {
        return new FullTextSharedSessionBuilderDelegator(super.sessionWithOptions());
    }

    public <T> T unwrap(Class<T> type) {
        if (type.equals(FullTextEntityManager.class)) {
            return (T)this;
        }
        if (type.equals(FullTextSession.class)) {
            return (T)this;
        }
        return (T)super.unwrap(type);
    }

    public SearchQuerySelectStep<?, ?, ?, SearchLoadingOptionsStep, ?, ?> search(V5MigrationSearchScope scope) {
        SearchSession searchSession = this.searchSession();
        return searchSession.search(((V5MigrationOrmSearchScopeAdapter)scope).toSearchScope());
    }

    private SearchSession searchSession() {
        return Search.session((Session)this.delegate);
    }
}

