/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.QueryTimeoutException;
import javax.persistence.TemporalType;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ScrollMode;
import org.hibernate.TypeMismatchException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.hql.internal.QueryExecutionRequestException;
import org.hibernate.query.ParameterMetadata;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.internal.AbstractProducedQuery;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.engine.search.query.SearchScroll;
import org.hibernate.search.impl.V5MigrationOrmSearchIntegratorAdapter;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.orm.search.loading.dsl.SearchLoadingOptionsStep;
import org.hibernate.search.mapper.orm.search.query.spi.HibernateOrmSearchScrollableResultsAdapter;
import org.hibernate.search.query.DatabaseRetrievalMethod;
import org.hibernate.search.query.ObjectLookupMethod;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.V5MigrationSearchSession;
import org.hibernate.search.query.hibernate.impl.EntityGraphHint;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.util.common.SearchTimeoutException;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;

public class FullTextQueryImpl
extends AbstractProducedQuery
implements FullTextQuery {
    private final V5MigrationSearchSession<SearchLoadingOptionsStep> searchSession;
    private final HSQuery hSearchQuery;
    private Integer firstResult;
    private Integer maxResults;
    private final Map<String, Object> hints = new HashMap<String, Object>(0);
    private Integer fetchSize = null;
    private EntityLoadingCacheLookupStrategy cacheLookupStrategy = null;
    private List<EntityGraphHint> entityGraphHints = new ArrayList<EntityGraphHint>();
    private final Consumer<SearchLoadingOptionsStep> loadingOptionsContributor = o -> {
        if (this.cacheLookupStrategy != null) {
            o.cacheLookupStrategy(this.cacheLookupStrategy);
        }
        if (this.fetchSize != null) {
            o.fetchSize(this.fetchSize.intValue());
        }
        for (EntityGraphHint hint : this.entityGraphHints) {
            o.graph(hint.graph, hint.semantic);
        }
    };
    private ResultTransformer resultTransformer;

    public FullTextQueryImpl(Query luceneQuery, SessionImplementor session, V5MigrationOrmSearchIntegratorAdapter searchIntegrator, V5MigrationSearchSession<SearchLoadingOptionsStep> searchSession, Class<?> ... entities) {
        super((SharedSessionContractImplementor)session, (ParameterMetadata)new ParameterMetadataImpl(null, null));
        this.searchSession = searchSession;
        this.hSearchQuery = searchIntegrator.createHSQuery(luceneQuery, searchSession, this.loadingOptionsContributor, entities);
    }

    @Override
    public FullTextQueryImpl setSort(Sort sort) {
        this.hSearchQuery.sort(sort);
        return this;
    }

    public List getResultList() {
        return this.list();
    }

    public Iterator iterate() {
        throw new UnsupportedOperationException("iterate() is not implemented in Hibernate Search queries. Use scroll() instead.");
    }

    public ScrollableResultsImplementor scroll() {
        SearchScroll scroll = this.hSearchQuery.scroll(this.fetchSize != null ? this.fetchSize : 100);
        return new HibernateOrmSearchScrollableResultsAdapter(scroll, this.maxResults != null ? this.maxResults : Integer.MAX_VALUE, (HibernateOrmSearchScrollableResultsAdapter.ScrollHitExtractor)Search5ScrollHitExtractor.INSTANCE);
    }

    public ScrollableResultsImplementor scroll(ScrollMode scrollMode) {
        return this.scroll();
    }

    public List list() {
        try {
            return this.doHibernateSearchList();
        }
        catch (SearchTimeoutException e) {
            throw new QueryTimeoutException((Throwable)e);
        }
        catch (QueryExecutionRequestException he) {
            throw new IllegalStateException(he);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    protected List doHibernateSearchList() {
        List list = this.hSearchQuery.fetch();
        if (this.resultTransformer != null) {
            list = this.resultTransformer.transformList(list);
        }
        return list;
    }

    @Override
    public Explanation explain(Object entityId) {
        return this.hSearchQuery.explain(entityId);
    }

    @Override
    public int getResultSize() {
        try {
            return this.doGetResultSize();
        }
        catch (SearchTimeoutException e) {
            throw new QueryTimeoutException((Throwable)e);
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    public int doGetResultSize() {
        return this.hSearchQuery.getResultSize();
    }

    @Override
    public FullTextQueryImpl applyGraph(RootGraph graph, GraphSemantic semantic) {
        this.entityGraphHints.add(new EntityGraphHint(graph, semantic));
        return this;
    }

    @Override
    public FullTextQueryImpl setProjection(String ... fields) {
        this.hSearchQuery.projection(fields);
        return this;
    }

    @Override
    public FullTextQueryImpl setSpatialParameters(Coordinates center, String fieldName) {
        this.hSearchQuery.setSpatialParameters(center, fieldName);
        return this;
    }

    @Override
    public FullTextQueryImpl setSpatialParameters(double latitude, double longitude, String fieldName) {
        this.setSpatialParameters((Coordinates)Point.fromDegrees((double)latitude, (double)longitude), fieldName);
        return this;
    }

    @Override
    public FullTextQuery setMaxResults(int maxResults) {
        if (maxResults < 0) {
            throw new IllegalArgumentException("Negative (" + maxResults + ") parameter passed in to setMaxResults");
        }
        this.hSearchQuery.maxResults(Integer.valueOf(maxResults));
        this.maxResults = maxResults;
        return this;
    }

    public int getMaxResults() {
        return this.maxResults == null || this.maxResults == -1 ? Integer.MAX_VALUE : this.maxResults;
    }

    @Override
    public FullTextQuery setFirstResult(int firstResult) {
        if (firstResult < 0) {
            throw new IllegalArgumentException("Negative (" + firstResult + ") parameter passed in to setFirstResult");
        }
        this.hSearchQuery.firstResult(firstResult);
        this.firstResult = firstResult;
        return this;
    }

    public int getFirstResult() {
        return this.firstResult == null ? 0 : this.firstResult;
    }

    @Override
    public FullTextQuery setHint(String hintName, Object value) {
        this.hints.put(hintName, value);
        switch (hintName) {
            case "javax.persistence.query.timeout": 
            case "jakarta.persistence.query.timeout": {
                this.setTimeout(FullTextQueryImpl.hintValueToInteger(value), TimeUnit.MILLISECONDS);
                break;
            }
            case "org.hibernate.timeout": {
                this.setTimeout(FullTextQueryImpl.hintValueToInteger(value));
                break;
            }
            case "javax.persistence.fetchgraph": 
            case "jakarta.persistence.fetchgraph": {
                this.applyGraph(FullTextQueryImpl.hintValueToEntityGraph(value), GraphSemantic.FETCH);
                break;
            }
            case "javax.persistence.loadgraph": 
            case "jakarta.persistence.loadgraph": {
                this.applyGraph(FullTextQueryImpl.hintValueToEntityGraph(value), GraphSemantic.LOAD);
                break;
            }
            default: {
                this.handleUnrecognizedHint(hintName, value);
            }
        }
        return this;
    }

    public Map<String, Object> getHints() {
        return this.hints;
    }

    public FullTextQueryImpl setParameter(Parameter tParameter, Object t) {
        throw this.parametersNoSupported();
    }

    public FullTextQueryImpl setParameter(Parameter calendarParameter, Calendar calendar, TemporalType temporalType) {
        throw this.parametersNoSupported();
    }

    public FullTextQueryImpl setParameter(Parameter dateParameter, Date date, TemporalType temporalType) {
        throw this.parametersNoSupported();
    }

    public FullTextQueryImpl setParameter(String name, Object value) {
        throw this.parametersNoSupported();
    }

    public FullTextQueryImpl setParameter(String name, Date value, TemporalType temporalType) {
        throw this.parametersNoSupported();
    }

    public FullTextQueryImpl setParameter(String name, Calendar value, TemporalType temporalType) {
        throw this.parametersNoSupported();
    }

    public FullTextQueryImpl setParameter(int position, Object value) {
        throw this.parametersNoSupported();
    }

    public FullTextQueryImpl setParameter(int position, Date value, TemporalType temporalType) {
        throw this.parametersNoSupported();
    }

    public Set<Parameter<?>> getParameters() {
        return Collections.EMPTY_SET;
    }

    protected QueryParameterBindings getQueryParameterBindings() {
        throw this.parametersNoSupported();
    }

    public FullTextQueryImpl setParameter(int position, Calendar value, TemporalType temporalType) {
        throw this.parametersNoSupported();
    }

    public QueryParameter<?> getParameter(String name) {
        throw this.parametersNoSupported();
    }

    public QueryParameter<?> getParameter(int position) {
        throw this.parametersNoSupported();
    }

    public QueryParameter getParameter(String name, Class type) {
        throw this.parametersNoSupported();
    }

    public QueryParameter getParameter(int position, Class type) {
        throw this.parametersNoSupported();
    }

    public boolean isBound(Parameter param) {
        throw this.parametersNoSupported();
    }

    public Object getParameterValue(Parameter param) {
        throw this.parametersNoSupported();
    }

    public Object getParameterValue(String name) {
        throw this.parametersNoSupported();
    }

    public Object getParameterValue(int position) {
        throw this.parametersNoSupported();
    }

    private UnsupportedOperationException parametersNoSupported() {
        return new UnsupportedOperationException("Parameters are not supported in Hibernate Search queries");
    }

    @Override
    public FullTextQueryImpl setFlushMode(FlushModeType flushModeType) {
        return (FullTextQueryImpl)super.setFlushMode(flushModeType);
    }

    @Override
    public FullTextQueryImpl setFetchSize(int fetchSize) {
        super.setFetchSize(fetchSize);
        if (fetchSize <= 0) {
            throw new IllegalArgumentException("'fetch size' parameter less than or equals to 0");
        }
        this.fetchSize = fetchSize;
        return this;
    }

    public QueryImplementor setLockOptions(LockOptions lockOptions) {
        throw this.lockOptionsNotSupported();
    }

    @Override
    @Deprecated
    public FullTextQueryImpl setResultTransformer(ResultTransformer transformer) {
        this.resultTransformer = transformer;
        if (transformer != null) {
            this.hSearchQuery.tupleTransformer((tuple, fields) -> this.resultTransformer.transformTuple(tuple, fields));
        } else {
            this.hSearchQuery.tupleTransformer(null);
        }
        return this;
    }

    public Object unwrap(Class type) {
        if (type == Query.class) {
            return this.hSearchQuery.getLuceneQuery();
        }
        throw new IllegalArgumentException("Cannot unwrap " + type.getName());
    }

    public FullTextQueryImpl setLockMode(LockModeType lockModeType) {
        throw this.lockOptionsNotSupported();
    }

    public LockModeType getLockMode() {
        throw this.lockOptionsNotSupported();
    }

    public LockOptions getLockOptions() {
        throw this.lockOptionsNotSupported();
    }

    private UnsupportedOperationException lockOptionsNotSupported() {
        return new UnsupportedOperationException("Lock options are not supported in Hibernate Search queries");
    }

    public int executeUpdate() {
        throw new UnsupportedOperationException("executeUpdate is not supported in Hibernate Search queries");
    }

    public QueryImplementor setLockMode(String alias, LockMode lockMode) {
        throw this.lockOptionsNotSupported();
    }

    @Override
    public FacetManager getFacetManager() {
        return this.hSearchQuery.getFacetManager();
    }

    public FullTextQueryImpl setTimeout(int timeout) {
        return this.setTimeout(timeout, TimeUnit.SECONDS);
    }

    @Override
    public FullTextQueryImpl setTimeout(long timeout, TimeUnit timeUnit) {
        this.hSearchQuery.failAfter(timeout, timeUnit);
        return this;
    }

    @Override
    public FullTextQueryImpl limitExecutionTimeTo(long timeout, TimeUnit timeUnit) {
        this.hSearchQuery.truncateAfter(timeout, timeUnit);
        return this;
    }

    @Override
    public boolean hasPartialResults() {
        return this.hSearchQuery.hasPartialResults();
    }

    @Override
    public FullTextQueryImpl initializeObjectsWith(ObjectLookupMethod lookupMethod, DatabaseRetrievalMethod retrievalMethod) {
        switch (lookupMethod) {
            case SKIP: {
                this.cacheLookupStrategy = EntityLoadingCacheLookupStrategy.SKIP;
                break;
            }
            case PERSISTENCE_CONTEXT: {
                this.cacheLookupStrategy = EntityLoadingCacheLookupStrategy.PERSISTENCE_CONTEXT;
                break;
            }
            case SECOND_LEVEL_CACHE: {
                this.cacheLookupStrategy = EntityLoadingCacheLookupStrategy.PERSISTENCE_CONTEXT_THEN_SECOND_LEVEL_CACHE;
            }
        }
        return this;
    }

    public String getQueryString() {
        return this.hSearchQuery.getQueryString();
    }

    protected boolean isNativeQuery() {
        return false;
    }

    @Deprecated
    public Type[] getReturnTypes() {
        throw new UnsupportedOperationException("getReturnTypes() is not implemented in Hibernate Search queries");
    }

    @Deprecated
    public String[] getReturnAliases() {
        throw new UnsupportedOperationException("getReturnAliases() is not implemented in Hibernate Search queries");
    }

    @Deprecated
    public FullTextQueryImpl setEntity(int position, Object val) {
        throw new UnsupportedOperationException("setEntity(int,Object) is not implemented in Hibernate Search queries");
    }

    @Deprecated
    public FullTextQueryImpl setEntity(String name, Object val) {
        throw new UnsupportedOperationException("setEntity(String,Object) is not implemented in Hibernate Search queries");
    }

    public String toString() {
        return "FullTextQueryImpl(" + this.getQueryString() + ")";
    }

    private static int hintValueToInteger(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(String.valueOf(value));
    }

    private static RootGraph<?> hintValueToEntityGraph(Object value) {
        return (RootGraph)value;
    }

    private static final class Search5ScrollHitExtractor
    implements HibernateOrmSearchScrollableResultsAdapter.ScrollHitExtractor<Object> {
        private static final Search5ScrollHitExtractor INSTANCE = new Search5ScrollHitExtractor();

        private Search5ScrollHitExtractor() {
        }

        public Object[] toArray(Object hit) {
            if (hit instanceof Object[]) {
                return (Object[])hit;
            }
            return new Object[]{hit};
        }

        public Object toElement(Object hit, int index) {
            if (hit instanceof Object[]) {
                return ((Object[])hit)[index];
            }
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return hit;
        }
    }
}

