/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.QueryTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ScrollMode;
import org.hibernate.TypeMismatchException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.KeyedPage;
import org.hibernate.query.KeyedResultList;
import org.hibernate.query.spi.AbstractQuery;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.engine.search.query.SearchScroll;
import org.hibernate.search.impl.V5MigrationOrmSearchIntegratorAdapter;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.orm.search.loading.dsl.SearchLoadingOptionsStep;
import org.hibernate.search.mapper.orm.search.query.spi.HibernateOrmSearchScrollableResultsAdapter;
import org.hibernate.search.query.DatabaseRetrievalMethod;
import org.hibernate.search.query.ObjectLookupMethod;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.V5MigrationSearchSession;
import org.hibernate.search.query.hibernate.impl.EntityGraphHint;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.util.common.SearchTimeoutException;
import org.hibernate.transform.ResultTransformer;

public class FullTextQueryImpl
extends AbstractQuery
implements FullTextQuery {
    private final V5MigrationSearchSession<SearchLoadingOptionsStep> searchSession;
    private final HSQuery hSearchQuery;
    private final Map<String, Object> hints = new HashMap<String, Object>(0);
    private Integer fetchSize = null;
    private EntityLoadingCacheLookupStrategy cacheLookupStrategy = null;
    private List<EntityGraphHint> entityGraphHints = new ArrayList<EntityGraphHint>();
    private final Consumer<SearchLoadingOptionsStep> loadingOptionsContributor = o -> {
        if (this.cacheLookupStrategy != null) {
            o.cacheLookupStrategy(this.cacheLookupStrategy);
        }
        if (this.fetchSize != null) {
            o.fetchSize(this.fetchSize.intValue());
        }
        for (EntityGraphHint hint : this.entityGraphHints) {
            o.graph(hint.graph, hint.semantic);
        }
    };
    private ResultTransformer resultTransformer;

    public FullTextQueryImpl(Query luceneQuery, SessionImplementor sessionImplementor, V5MigrationOrmSearchIntegratorAdapter searchIntegrator, V5MigrationSearchSession<SearchLoadingOptionsStep> searchSession, Class<?> ... entities) {
        super((SharedSessionContractImplementor)sessionImplementor);
        this.searchSession = searchSession;
        this.hSearchQuery = searchIntegrator.createHSQuery(luceneQuery, searchSession, this.loadingOptionsContributor, entities);
    }

    @Override
    public FullTextQueryImpl setSort(Sort sort) {
        this.hSearchQuery.sort(sort);
        return this;
    }

    public List getResultList() {
        return this.list();
    }

    public ScrollableResultsImplementor scroll() {
        return this.scroll(ScrollMode.FORWARD_ONLY);
    }

    public long getResultCount() {
        return this.hSearchQuery.getResultSize();
    }

    public KeyedResultList getKeyedResultList(KeyedPage page) {
        throw new UnsupportedOperationException("Query " + String.valueOf(this) + " does not implement getKeyedResultList(...).");
    }

    protected ScrollableResultsImplementor doScroll(ScrollMode scrollMode) {
        SearchScroll scroll = this.hSearchQuery.scroll(this.fetchSize != null ? this.fetchSize : 100);
        Integer maxResults = this.hSearchQuery.maxResults();
        return new HibernateOrmSearchScrollableResultsAdapter(scroll, maxResults != null ? maxResults : Integer.MAX_VALUE, (Function)Search5ScrollHitExtractor.INSTANCE);
    }

    public List list() {
        try {
            return super.list();
        }
        catch (SearchTimeoutException e) {
            throw new QueryTimeoutException((Throwable)e);
        }
    }

    protected List doList() {
        List list = this.hSearchQuery.fetch();
        if (this.resultTransformer != null) {
            list = this.resultTransformer.transformList(list);
        }
        return list;
    }

    protected void beforeQuery() {
        super.beforeQuery();
        this.extractQueryOptions();
    }

    private void extractQueryOptions() {
        Integer queryTimeout;
        MutableQueryOptions queryOptions = this.getQueryOptions();
        Integer limit = queryOptions.getLimit().getMaxRows();
        this.hSearchQuery.maxResults(limit);
        Integer offset = queryOptions.getLimit().getFirstRow();
        this.hSearchQuery.firstResult(offset == null ? 0 : offset);
        Integer queryFetchSize = queryOptions.getFetchSize();
        if (queryFetchSize != null) {
            this.fetchSize = queryFetchSize;
        }
        if ((queryTimeout = queryOptions.getTimeout()) != null) {
            this.hSearchQuery.failAfter((long)queryTimeout.intValue(), TimeUnit.SECONDS);
        }
    }

    @Override
    public Explanation explain(Object entityId) {
        return this.hSearchQuery.explain(entityId);
    }

    @Override
    public int getResultSize() {
        try {
            return this.doGetResultSize();
        }
        catch (SearchTimeoutException e) {
            throw new QueryTimeoutException((Throwable)e);
        }
        catch (IllegalQueryOperationException e) {
            throw new IllegalStateException(e);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            throw this.getSession().getExceptionConverter().convert(he, this.getLockOptions());
        }
    }

    public int doGetResultSize() {
        return this.hSearchQuery.getResultSize();
    }

    @Override
    public FullTextQuery applyGraph(RootGraph graph, GraphSemantic semantic) {
        this.applyGraph((RootGraphImplementor)graph, semantic);
        return this;
    }

    protected void applyGraph(RootGraphImplementor<?> graph, GraphSemantic semantic) {
        this.entityGraphHints.add(new EntityGraphHint((RootGraph<?>)graph, semantic));
    }

    @Override
    public FullTextQueryImpl setProjection(String ... fields) {
        this.hSearchQuery.projection(fields);
        return this;
    }

    @Override
    public FullTextQueryImpl setSpatialParameters(Coordinates center, String fieldName) {
        this.hSearchQuery.setSpatialParameters(center, fieldName);
        return this;
    }

    @Override
    public FullTextQueryImpl setSpatialParameters(double latitude, double longitude, String fieldName) {
        this.setSpatialParameters((Coordinates)Point.fromDegrees((double)latitude, (double)longitude), fieldName);
        return this;
    }

    @Override
    public FullTextQuery setMaxResults(int maxResults) {
        super.setMaxResults(maxResults);
        return this;
    }

    @Override
    public FullTextQuery setFirstResult(int firstResult) {
        super.setFirstResult(firstResult);
        return this;
    }

    @Override
    public FullTextQuery setHint(String hintName, Object value) {
        this.hints.put(hintName, value);
        switch (hintName) {
            case "javax.persistence.query.timeout": 
            case "jakarta.persistence.query.timeout": {
                this.setTimeout(FullTextQueryImpl.hintValueToInteger(value), TimeUnit.MILLISECONDS);
                break;
            }
            case "org.hibernate.timeout": {
                this.setTimeout(FullTextQueryImpl.hintValueToInteger(value));
                break;
            }
            case "javax.persistence.fetchgraph": 
            case "jakarta.persistence.fetchgraph": 
            case "javax.persistence.loadgraph": 
            case "jakarta.persistence.loadgraph": {
                this.applyEntityGraphHint(hintName, FullTextQueryImpl.hintValueToEntityGraph(value));
                break;
            }
        }
        return this;
    }

    public Map<String, Object> getHints() {
        return this.hints;
    }

    public ParameterMetadataImplementor getParameterMetadata() {
        throw this.parametersNoSupported();
    }

    public QueryParameterBindings getParameterBindings() {
        return QueryParameterBindings.NO_PARAM_BINDINGS;
    }

    public QueryParameterBindings getQueryParameterBindings() {
        return QueryParameterBindings.NO_PARAM_BINDINGS;
    }

    protected QueryParameterBinding locateBinding(String name) {
        throw this.parametersNoSupported();
    }

    protected QueryParameterBinding locateBinding(int position) {
        throw this.parametersNoSupported();
    }

    protected QueryParameterBinding locateBinding(Parameter parameter) {
        throw this.parametersNoSupported();
    }

    protected QueryParameterBinding locateBinding(QueryParameterImplementor parameter) {
        throw this.parametersNoSupported();
    }

    private UnsupportedOperationException parametersNoSupported() {
        return new UnsupportedOperationException("Parameters are not supported in Hibernate Search queries");
    }

    @Override
    public FullTextQueryImpl setFlushMode(FlushModeType flushModeType) {
        return (FullTextQueryImpl)super.setFlushMode(flushModeType);
    }

    @Override
    public FullTextQueryImpl setFetchSize(int fetchSize) {
        return (FullTextQueryImpl)super.setFetchSize(fetchSize);
    }

    public QueryImplementor setLockOptions(LockOptions lockOptions) {
        throw this.lockOptionsNotSupported();
    }

    @Override
    @Deprecated
    public FullTextQueryImpl setResultTransformer(ResultTransformer transformer) {
        this.resultTransformer = transformer;
        if (transformer != null) {
            this.hSearchQuery.tupleTransformer((tuple, fields) -> this.resultTransformer.transformTuple(tuple, fields));
        } else {
            this.hSearchQuery.tupleTransformer(null);
        }
        return this;
    }

    public Object unwrap(Class type) {
        if (type == Query.class) {
            return this.hSearchQuery.getLuceneQuery();
        }
        if (type.isInstance(this)) {
            return this;
        }
        throw new PersistenceException("Unrecognized unwrap type [" + type.getName() + "]");
    }

    public FullTextQueryImpl setLockMode(LockModeType lockModeType) {
        throw this.lockOptionsNotSupported();
    }

    public LockModeType getLockMode() {
        throw this.lockOptionsNotSupported();
    }

    public LockOptions getLockOptions() {
        throw this.lockOptionsNotSupported();
    }

    private UnsupportedOperationException lockOptionsNotSupported() {
        return new UnsupportedOperationException("Lock options are not supported in Hibernate Search queries");
    }

    public int executeUpdate() throws HibernateException {
        return this.doExecuteUpdate();
    }

    protected int doExecuteUpdate() {
        throw new UnsupportedOperationException("executeUpdate() is not supported in Hibernate Search queries");
    }

    public QueryImplementor setLockMode(String alias, LockMode lockMode) {
        throw this.lockOptionsNotSupported();
    }

    @Override
    public FacetManager getFacetManager() {
        return this.hSearchQuery.getFacetManager();
    }

    public FullTextQueryImpl setTimeout(int timeout) {
        return this.setTimeout(timeout, TimeUnit.SECONDS);
    }

    @Override
    public FullTextQueryImpl setTimeout(long timeout, TimeUnit timeUnit) {
        this.hSearchQuery.failAfter(timeout, timeUnit);
        return this;
    }

    @Override
    public FullTextQueryImpl limitExecutionTimeTo(long timeout, TimeUnit timeUnit) {
        this.hSearchQuery.truncateAfter(timeout, timeUnit);
        return this;
    }

    @Override
    public boolean hasPartialResults() {
        return this.hSearchQuery.hasPartialResults();
    }

    @Override
    public FullTextQueryImpl initializeObjectsWith(ObjectLookupMethod lookupMethod, DatabaseRetrievalMethod retrievalMethod) {
        switch (lookupMethod) {
            case SKIP: {
                this.cacheLookupStrategy = EntityLoadingCacheLookupStrategy.SKIP;
                break;
            }
            case PERSISTENCE_CONTEXT: {
                this.cacheLookupStrategy = EntityLoadingCacheLookupStrategy.PERSISTENCE_CONTEXT;
                break;
            }
            case SECOND_LEVEL_CACHE: {
                this.cacheLookupStrategy = EntityLoadingCacheLookupStrategy.PERSISTENCE_CONTEXT_THEN_SECOND_LEVEL_CACHE;
            }
        }
        return this;
    }

    public String getQueryString() {
        return this.hSearchQuery.getQueryString();
    }

    public String toString() {
        return "FullTextQueryImpl(" + this.getQueryString() + ")";
    }

    private static int hintValueToInteger(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(String.valueOf(value));
    }

    private static RootGraphImplementor<?> hintValueToEntityGraph(Object value) {
        return (RootGraphImplementor)value;
    }

    private static final class Search5ScrollHitExtractor
    implements Function<Object, Object[]> {
        private static final Search5ScrollHitExtractor INSTANCE = new Search5ScrollHitExtractor();

        private Search5ScrollHitExtractor() {
        }

        @Override
        public Object[] apply(Object hit) {
            if (hit instanceof Object[]) {
                return (Object[])hit;
            }
            return new Object[]{hit};
        }
    }
}

