/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.maven;

import java.io.File;
import java.util.EnumSet;
import java.util.Set;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.hibernate.boot.Metadata;
import org.hibernate.tool.api.metadata.MetadataDescriptor;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.maven.AbstractGenerationMojo;
import org.hibernate.tool.schema.TargetType;

@Mojo(name="hbm2ddl", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class GenerateDdlMojo
extends AbstractGenerationMojo {
    @Parameter(defaultValue="${project.build.directory}/generated-resources/")
    private File outputDirectory;
    @Parameter(defaultValue="schema.ddl")
    private String outputFileName;
    @Parameter(defaultValue="SCRIPT")
    private Set<TargetType> targetTypes;
    @Parameter(defaultValue="CREATE")
    private SchemaExport.Action schemaExportAction;
    @Parameter(defaultValue=";")
    private String delimiter;
    @Parameter(defaultValue="true")
    private boolean format;
    @Parameter(defaultValue="true")
    private boolean haltOnError;

    @Override
    protected void executeExporter(MetadataDescriptor metadataDescriptor) {
        Metadata metadata = metadataDescriptor.createMetadata();
        SchemaExport export = new SchemaExport();
        export.setOutputFile(new File(this.outputDirectory, this.outputFileName).toString());
        export.setDelimiter(this.delimiter);
        export.setHaltOnError(this.haltOnError);
        export.setFormat(this.format);
        export.execute(EnumSet.copyOf(this.targetTypes), this.schemaExportAction, metadata);
    }
}

