/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.maven;

import java.io.File;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.hibernate.tool.api.export.Exporter;
import org.hibernate.tool.api.export.ExporterFactory;
import org.hibernate.tool.api.export.ExporterType;
import org.hibernate.tool.api.metadata.MetadataDescriptor;
import org.hibernate.tool.maven.AbstractGenerationMojo;

@Mojo(name="generateHbm", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class GenerateHbmMojo
extends AbstractGenerationMojo {
    @Parameter(defaultValue="${project.basedir}/src/main/resources")
    private File outputDirectory;
    @Parameter
    private String templatePath;

    @Override
    protected void executeExporter(MetadataDescriptor metadataDescriptor) {
        try {
            Exporter hbmExporter = ExporterFactory.createExporter((ExporterType)ExporterType.HBM);
            hbmExporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.MetadataDescriptor", metadataDescriptor);
            hbmExporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.DestinationFolder", this.outputDirectory);
            if (this.templatePath != null) {
                this.getLog().info((CharSequence)("Setting template path to: " + this.templatePath));
                hbmExporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.TemplatePath", new String[]{this.templatePath});
            }
            this.getLog().info((CharSequence)("Starting HBM export to directory: " + this.outputDirectory + "..."));
            hbmExporter.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

