/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.maven;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.transform.HbmXmlTransformer;
import org.hibernate.boot.jaxb.hbm.transform.UnsupportedFeatureHandling;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.service.ServiceRegistry;

@Mojo(name="hbm2orm", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class TransformHbmMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.basedir}/src/main/resources")
    private File inputFolder;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MappingBinder mappingBinder = new MappingBinder(MappingBinder.class.getClassLoader()::getResourceAsStream, UnsupportedFeatureHandling.ERROR);
        List<File> hbmFiles = this.getHbmFiles(this.inputFolder);
        List<Binding<JaxbHbmHibernateMapping>> hbmMappings = this.getHbmMappings(hbmFiles, mappingBinder);
        this.performTransformation(hbmMappings, mappingBinder, this.createServiceRegistry());
    }

    private ServiceRegistry createServiceRegistry() {
        StandardServiceRegistryBuilder ssrb = new StandardServiceRegistryBuilder();
        ssrb.clearSettings();
        ssrb.applySetting("hibernate.boot.allow_jdbc_metadata_access", (Object)false);
        ssrb.applySetting("hibernate.dialect", (Object)H2Dialect.class.getName());
        return ssrb.build();
    }

    private void performTransformation(List<Binding<JaxbHbmHibernateMapping>> hbmBindings, MappingBinder mappingBinder, ServiceRegistry serviceRegistry) {
        Marshaller marshaller = this.createMarshaller(mappingBinder);
        MetadataSources metadataSources = new MetadataSources(serviceRegistry);
        hbmBindings.forEach(arg_0 -> ((MetadataSources)metadataSources).addHbmXmlBinding(arg_0));
        List transformedBindings = HbmXmlTransformer.transform(hbmBindings, (MetadataImplementor)((MetadataImplementor)metadataSources.buildMetadata()), (UnsupportedFeatureHandling)UnsupportedFeatureHandling.ERROR);
        for (int i = 0; i < hbmBindings.size(); ++i) {
            Binding<JaxbHbmHibernateMapping> hbmBinding = hbmBindings.get(i);
            Binding transformedBinding = (Binding)transformedBindings.get(i);
            HbmXmlOrigin origin = (HbmXmlOrigin)hbmBinding.getOrigin();
            File hbmXmlFile = origin.getHbmXmlFile();
            this.marshall(marshaller, (JaxbEntityMappingsImpl)transformedBinding.getRoot(), hbmXmlFile);
        }
    }

    private List<Binding<JaxbHbmHibernateMapping>> getHbmMappings(List<File> hbmXmlFiles, MappingBinder mappingBinder) {
        ArrayList<Binding<JaxbHbmHibernateMapping>> result = new ArrayList<Binding<JaxbHbmHibernateMapping>>();
        hbmXmlFiles.forEach(hbmXmlFile -> {
            String fullPath = hbmXmlFile.getAbsolutePath();
            this.getLog().info((CharSequence)("Adding file: '" + fullPath + "' to the list to be transformed."));
            HbmXmlOrigin origin = new HbmXmlOrigin((File)hbmXmlFile);
            Binding<JaxbHbmHibernateMapping> binding = this.bindMapping(mappingBinder, (File)hbmXmlFile, origin);
            result.add(binding);
        });
        return result;
    }

    private void marshall(Marshaller marshaller, JaxbEntityMappingsImpl mappings, File hbmXmlFile) {
        File mappingXmlFile = new File(hbmXmlFile.getParentFile(), hbmXmlFile.getName().replace(".hbm.xml", ".mapping.xml"));
        this.getLog().info((CharSequence)("Marshalling file: " + hbmXmlFile.getAbsolutePath() + " into " + mappingXmlFile.getAbsolutePath()));
        try {
            marshaller.marshal((Object)mappings, mappingXmlFile);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to marshall mapping JAXB representation to file `" + mappingXmlFile.getAbsolutePath() + "`", e);
        }
    }

    private Binding<JaxbHbmHibernateMapping> bindMapping(MappingBinder mappingBinder, File hbmXmlFile, Origin origin) {
        Binding binding;
        FileInputStream fileStream = new FileInputStream(hbmXmlFile);
        try {
            binding = mappingBinder.bind((InputStream)fileStream, origin);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Unable to open hbm.xml file `" + hbmXmlFile.getAbsolutePath() + "` for transformation"), (Throwable)e);
                return null;
            }
        }
        fileStream.close();
        return binding;
    }

    private Marshaller createMarshaller(MappingBinder mappingBinder) {
        try {
            return mappingBinder.mappingJaxbContext().createMarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to create JAXB Marshaller", e);
        }
    }

    private List<File> getHbmFiles(File f) {
        ArrayList<File> result = new ArrayList<File>();
        if (f.isFile()) {
            if (f.getName().endsWith("hbm.xml")) {
                result.add(f);
            }
        } else {
            for (File child : f.listFiles()) {
                result.addAll(this.getHbmFiles(child));
            }
        }
        return result;
    }

    private class HbmXmlOrigin
    extends Origin {
        private static final long serialVersionUID = 1L;
        private final File hbmXmlFile;

        public HbmXmlOrigin(File hbmXmlFile) {
            super(SourceType.FILE, hbmXmlFile.getAbsolutePath());
            this.hbmXmlFile = hbmXmlFile;
        }

        public File getHbmXmlFile() {
            return this.hbmXmlFile;
        }
    }
}

