/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.api.reveng.TableIdentifier;
import org.hibernate.tool.internal.util.TableNameQualifier;

public class RevengMetadataCollector {
    private MetadataBuildingContext metadataBuildingContext = null;
    private final Map<TableIdentifier, Table> tables = new HashMap<TableIdentifier, Table>();
    private Map<String, List<ForeignKey>> oneToManyCandidates;
    private final Map<TableIdentifier, String> suggestedIdentifierStrategies = new HashMap<TableIdentifier, String>();

    public RevengMetadataCollector(MetadataBuildingContext metadataBuildingContext) {
        this();
        this.metadataBuildingContext = metadataBuildingContext;
    }

    public RevengMetadataCollector() {
    }

    public Iterator<Table> iterateTables() {
        return this.tables.values().iterator();
    }

    public Table addTable(TableIdentifier tableIdentifier) {
        Table result = null;
        String catalog = tableIdentifier.getCatalog();
        String schema = tableIdentifier.getSchema();
        String name = tableIdentifier.getName();
        InFlightMetadataCollector metadataCollector = this.getMetadataCollector();
        result = metadataCollector != null ? metadataCollector.addTable(schema, catalog, name, null, false, this.metadataBuildingContext) : this.createTable(catalog, schema, name);
        if (this.tables.containsKey(tableIdentifier)) {
            throw new RuntimeException("Attempt to add a double entry for table: " + TableNameQualifier.qualify(catalog, schema, name));
        }
        this.tables.put(tableIdentifier, result);
        return result;
    }

    public Table getTable(TableIdentifier tableIdentifier) {
        return this.tables.get(tableIdentifier);
    }

    public Collection<Table> getTables() {
        return this.tables.values();
    }

    public void setOneToManyCandidates(Map<String, List<ForeignKey>> oneToManyCandidates) {
        this.oneToManyCandidates = oneToManyCandidates;
    }

    public Map<String, List<ForeignKey>> getOneToManyCandidates() {
        return this.oneToManyCandidates;
    }

    public String getSuggestedIdentifierStrategy(String catalog, String schema, String name) {
        return this.suggestedIdentifierStrategies.get(TableIdentifier.create(catalog, schema, name));
    }

    public void addSuggestedIdentifierStrategy(String catalog, String schema, String name, String idstrategy) {
        this.suggestedIdentifierStrategies.put(TableIdentifier.create(catalog, schema, name), idstrategy);
    }

    private Table createTable(String catalog, String schema, String name) {
        Table table = new Table("Hibernate Tools");
        table.setAbstract(false);
        table.setName(name);
        table.setSchema(schema);
        table.setCatalog(catalog);
        return table;
    }

    private InFlightMetadataCollector getMetadataCollector() {
        InFlightMetadataCollector result = null;
        if (this.metadataBuildingContext != null) {
            result = this.metadataBuildingContext.getMetadataCollector();
        }
        return result;
    }
}

