/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ide.completion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.hibernate.tool.ide.completion.AntlrSimpleHQLLexer;
import org.hibernate.tool.ide.completion.EntityNameReference;
import org.hibernate.tool.ide.completion.SimpleHQLLexer;
import org.hibernate.tool.ide.completion.SubQuery;

public class HQLAnalyzer {
    private static String[] hqlKeywords = new String[]{"between", "class", "delete", "desc", "distinct", "elements", "escape", "exists", "false", "fetch", "from", "full", "group", "having", "in", "indices", "inner", "insert", "into", "is", "join", "left", "like", "new", "not", "null", "or", "order", "outer", "properties", "right", "select", "set", "some", "true", "union", "update", "versioned", "where", "and", "or", "as", "on", "with", "both", "empty", "leading", "member", "object", "of", "trailing"};
    private static String[] builtInFunctions = new String[]{"substring", "locate", "trim", "length", "bit_length", "coalesce", "nullif", "abs", "mod", "sqrt", "upper", "lower", "cast", "extract", "second", "minute", "hour", "day", "month", "year", "str", "sign", "acos", "asin", "atan", "cos", "cosh", "exp", "ln", "sin", "sinh", "stddev", "sqrt", "tan", "tanh", "variance", "round", "trunc", "ceil", "floor", "chr", "initcap", "lower", "ltrim", "rtrim", "soundex", "upper", "ascii", "length", "to_char", "to_date", "current_date", "current_time", "current_timestamp", "lastday", "sysday", "systimestamp", "uid", "user", "rowid", "rownum", "concat", "instr", "instrb", "lpad", "replace", "rpad", "substr", "substrb", "translate", "substring", "locate", "bit_length", "coalesce", "atan2", "log", "mod", "nvl", "nvl2", "power", "add_months", "months_between", "next_day", "max", "min"};

    protected SimpleHQLLexer getLexer(char[] chars, int end) {
        return new AntlrSimpleHQLLexer(chars, end);
    }

    protected SimpleHQLLexer getLexer(char[] chars) {
        return new AntlrSimpleHQLLexer(chars, chars.length);
    }

    public boolean shouldShowEntityNames(String query, int cursorPosition) {
        return this.shouldShowEntityNames(query.toCharArray(), cursorPosition);
    }

    public boolean shouldShowEntityNames(char[] chars, int cursorPosition) {
        SimpleHQLLexer lexer = this.getLexer(chars, cursorPosition);
        int tokenId = -1;
        boolean show = false;
        while ((tokenId = lexer.nextTokenId()) != -1) {
            if ((tokenId == 106 || tokenId == 81 || tokenId == 227) && lexer.getTokenOffset() + lexer.getTokenLength() < cursorPosition) {
                show = true;
                continue;
            }
            if (tokenId == 23 || tokenId == 52 || tokenId == 22 || tokenId == 252 || tokenId == 1) continue;
            show = false;
        }
        return show;
    }

    public List<SubQuery> getVisibleSubQueries(char[] chars, int position) {
        SubQueryList sqList = this.getSubQueries(chars, position);
        ArrayList<SubQuery> visible = new ArrayList<SubQuery>();
        for (SubQuery sq : sqList.subQueries) {
            if (sqList.caretDepth < sq.depth || sq.startOffset > position && sq.endOffset < position) continue;
            visible.add(sq);
        }
        return visible;
    }

    public List<EntityNameReference> getVisibleEntityNames(char[] chars, int position) {
        List<SubQuery> sqs = this.getVisibleSubQueries(chars, position);
        ArrayList<EntityNameReference> entityReferences = new ArrayList<EntityNameReference>();
        for (SubQuery sq : sqs) {
            entityReferences.addAll(sq.getEntityNames());
        }
        return entityReferences;
    }

    public SubQueryList getSubQueries(char[] query, int position) {
        SimpleHQLLexer syntax = this.getLexer(query);
        int numericId = -1;
        ArrayList<SubQuery> subQueries = new ArrayList<SubQuery>();
        int depth = 0;
        int caretDepth = 0;
        HashMap<Integer, SubQuery> level2SubQuery = new HashMap<Integer, SubQuery>();
        SubQuery current = null;
        block3: while ((numericId = syntax.nextTokenId()) != -1) {
            boolean tokenAdded = false;
            if (numericId == 24) {
                ++depth;
                if (position > syntax.getTokenOffset()) {
                    caretDepth = depth;
                }
            } else if (numericId == 25) {
                SubQuery currentDepthQuery = (SubQuery)level2SubQuery.get(depth);
                if (currentDepthQuery != null && currentDepthQuery.depth == depth) {
                    currentDepthQuery.endOffset = syntax.getTokenOffset();
                    currentDepthQuery.tokenIds.add(numericId);
                    currentDepthQuery.tokenText.add(String.valueOf(query, syntax.getTokenOffset(), syntax.getTokenLength()));
                    subQueries.add(currentDepthQuery);
                    level2SubQuery.remove(depth);
                    tokenAdded = true;
                }
                --depth;
                if (position > syntax.getTokenOffset()) {
                    caretDepth = depth;
                }
            }
            switch (numericId) {
                case 81: 
                case 106: 
                case 204: 
                case 227: {
                    if (!level2SubQuery.containsKey(depth)) {
                        current = new SubQuery();
                        current.depth = depth;
                        current.startOffset = syntax.getTokenOffset();
                        level2SubQuery.put(depth, current);
                    }
                    current.tokenIds.add(numericId);
                    current.tokenText.add(String.valueOf(query, syntax.getTokenOffset(), syntax.getTokenLength()));
                    continue block3;
                }
            }
            if (tokenAdded) continue;
            SubQuery sq = (SubQuery)level2SubQuery.get(depth);
            int i = depth;
            while (sq == null && i >= 0) {
                sq = (SubQuery)level2SubQuery.get(i--);
            }
            if (sq == null) continue;
            sq.tokenIds.add(numericId);
            sq.tokenText.add(String.valueOf(query, syntax.getTokenOffset(), syntax.getTokenLength()));
        }
        for (SubQuery sq : level2SubQuery.values()) {
            sq.endOffset = syntax.getTokenOffset() + syntax.getTokenLength();
            subQueries.add(sq);
        }
        Collections.sort(subQueries);
        SubQueryList sql = new SubQueryList();
        sql.caretDepth = caretDepth;
        sql.subQueries = subQueries;
        return sql;
    }

    public static String getEntityNamePrefix(char[] chars, int position) {
        char c;
        StringBuffer buff = new StringBuffer();
        for (int i = position - 1; i >= 0 && ((c = chars[i]) == '.' || Character.isJavaIdentifierPart(c)); --i) {
            buff.insert(0, c);
        }
        return buff.toString();
    }

    static String[] getHQLKeywords() {
        return hqlKeywords;
    }

    static String[] getHQLFunctionNames() {
        return builtInFunctions;
    }

    static {
        Arrays.sort(builtInFunctions);
        Arrays.sort(hqlKeywords);
    }

    public static class SubQueryList {
        int caretDepth;
        public List<SubQuery> subQueries;
    }
}

