/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng.reader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.JDBCException;
import org.hibernate.MappingException;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.api.reveng.RevengDialect;
import org.hibernate.tool.api.reveng.RevengStrategy;
import org.hibernate.tool.api.reveng.TableIdentifier;
import org.hibernate.tool.internal.reveng.RevengMetadataCollector;
import org.hibernate.tool.internal.reveng.reader.ForeignKeysInfo;
import org.hibernate.tool.internal.reveng.util.RevengUtils;
import org.hibernate.tool.internal.util.StringUtil;
import org.hibernate.tool.internal.util.TableNameQualifier;
import org.jboss.logging.Logger;

public class ForeignKeyProcessor {
    private static final Logger log = Logger.getLogger(ForeignKeyProcessor.class);
    private final RevengDialect metaDataDialect;
    private final RevengStrategy revengStrategy;
    private final String defaultSchema;
    private final String defaultCatalog;
    private final RevengMetadataCollector revengMetadataCollector;
    private short bogusFkName = 0;

    public static ForeignKeyProcessor create(RevengDialect metaDataDialect, RevengStrategy revengStrategy, String defaultCatalog, String defaultSchema, RevengMetadataCollector revengMetadataCollector) {
        return new ForeignKeyProcessor(metaDataDialect, revengStrategy, defaultCatalog, defaultSchema, revengMetadataCollector);
    }

    private ForeignKeyProcessor(RevengDialect metaDataDialect, RevengStrategy revengStrategy, String defaultCatalog, String defaultSchema, RevengMetadataCollector revengMetadataCollector) {
        this.metaDataDialect = metaDataDialect;
        this.revengStrategy = revengStrategy;
        this.defaultCatalog = defaultCatalog;
        this.defaultSchema = defaultSchema;
        this.revengMetadataCollector = revengMetadataCollector;
    }

    public ForeignKeysInfo processForeignKeys(Table referencedTable) {
        HashMap<String, List<Column>> dependentColumns = new HashMap<String, List<Column>>();
        HashMap<String, Table> dependentTables = new HashMap<String, Table>();
        HashMap<String, List<Column>> referencedColumns = new HashMap<String, List<Column>>();
        this.processExportedForeignKeys(referencedTable, dependentColumns, dependentTables, referencedColumns);
        this.processUserForeignKeys(referencedTable, dependentColumns, dependentTables, referencedColumns);
        return new ForeignKeysInfo(referencedTable, dependentTables, dependentColumns, referencedColumns);
    }

    private void processUserForeignKeys(Table referencedTable, Map<String, List<Column>> dependentColumns, Map<String, Table> dependentTables, Map<String, List<Column>> referencedColumns) {
        List<ForeignKey> userForeignKeys = this.revengStrategy.getForeignKeys(RevengUtils.createTableIdentifier(referencedTable, this.defaultCatalog, this.defaultSchema));
        if (userForeignKeys != null) {
            Iterator<ForeignKey> iterator = userForeignKeys.iterator();
            while (iterator.hasNext()) {
                this.processUserForeignKey(iterator.next(), referencedTable, referencedColumns, dependentColumns, dependentTables);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExportedForeignKeys(Table referencedTable, Map<String, List<Column>> dependentColumns, Map<String, Table> dependentTables, Map<String, List<Column>> referencedColumns) {
        try {
            log.debug((Object)("Calling getExportedKeys on " + String.valueOf(referencedTable)));
            Iterator<Map<String, Object>> exportedKeyIterator = this.metaDataDialect.getExportedKeys(ForeignKeyProcessor.getCatalogForDBLookup(referencedTable.getCatalog(), this.defaultCatalog), ForeignKeyProcessor.getSchemaForDBLookup(referencedTable.getSchema(), this.defaultSchema), referencedTable.getName());
            try {
                while (exportedKeyIterator.hasNext()) {
                    this.processExportedKey(exportedKeyIterator.next(), this.bogusFkName, dependentColumns, dependentTables, referencedColumns, referencedTable);
                }
            }
            finally {
                try {
                    if (exportedKeyIterator != null) {
                        this.metaDataDialect.close(exportedKeyIterator);
                    }
                }
                catch (JDBCException se) {
                    log.warn((Object)"Exception while closing result set for foreign key meta data", (Throwable)se);
                }
            }
        }
        catch (JDBCException se) {
            log.warn((Object)("Exception while reading foreign keys for " + String.valueOf(referencedTable) + " [" + se.toString() + "]"), (Throwable)se);
        }
    }

    private void processExportedKey(Map<String, Object> exportedKeyRs, short bogusFkName, Map<String, List<Column>> dependentColumns, Map<String, Table> dependentTables, Map<String, List<Column>> referencedColumns, Table referencedTable) {
        String fkName = this.determineForeignKeyName(exportedKeyRs, bogusFkName);
        Table fkTable = this.determineForeignKeyTable(exportedKeyRs, fkName);
        if (fkTable != null) {
            log.debug((Object)("Foreign key " + fkName));
            this.handleDependencies(exportedKeyRs, dependentColumns, dependentTables, fkTable, fkName);
            this.handleReferences(exportedKeyRs, referencedColumns, referencedTable, fkName);
        }
    }

    private Table determineForeignKeyTable(Map<String, Object> exportedKeyRs, String fkName) {
        String fkTableName;
        String fkSchema;
        String fkCatalog;
        Table fkTable = this.getTable((String)exportedKeyRs.get("FKTABLE_CAT"), (String)exportedKeyRs.get("FKTABLE_SCHEM"), (String)exportedKeyRs.get("FKTABLE_NAME"));
        if (fkTable == null && (fkTable = this.getTable(fkCatalog = ForeignKeyProcessor.getCatalogForModel((String)exportedKeyRs.get("FKTABLE_CAT"), this.defaultCatalog), fkSchema = ForeignKeyProcessor.getSchemaForModel((String)exportedKeyRs.get("FKTABLE_SCHEM"), this.defaultSchema), fkTableName = (String)exportedKeyRs.get("FKTABLE_NAME"))) == null) {
            log.debug((Object)("Foreign key " + fkName + " references unknown or filtered table " + TableNameQualifier.qualify(fkCatalog, fkSchema, fkTableName)));
        }
        return fkTable;
    }

    private String determineForeignKeyName(Map<String, Object> exportedKeyRs, short bogusFkName) {
        String fkName = (String)exportedKeyRs.get("FK_NAME");
        if (fkName == null) {
            short s = bogusFkName;
            bogusFkName = (short)(bogusFkName + 1);
            fkName = Short.toString(s);
        }
        return fkName;
    }

    private void handleReferences(Map<String, Object> exportedKeyRs, Map<String, List<Column>> referencedColumns, Table referencedTable, String fkName) {
        Column refColumn;
        Column existingColumn;
        List<Column> primColumns = referencedColumns.get(fkName);
        if (primColumns == null) {
            primColumns = new ArrayList<Column>();
            referencedColumns.put(fkName, primColumns);
        }
        if ((existingColumn = referencedTable.getColumn(refColumn = new Column((String)exportedKeyRs.get("PKCOLUMN_NAME")))) != null) {
            primColumns.add(existingColumn);
        } else {
            primColumns.add(refColumn);
        }
    }

    private void handleDependencies(Map<String, Object> exportedKeyRs, Map<String, List<Column>> dependentColumns, Map<String, Table> dependentTables, Table fkTable, String fkName) {
        String fkColumnName = (String)exportedKeyRs.get("FKCOLUMN_NAME");
        List<Column> depColumns = dependentColumns.get(fkName);
        if (depColumns == null) {
            depColumns = new ArrayList<Column>();
            dependentColumns.put(fkName, depColumns);
            dependentTables.put(fkName, fkTable);
        } else {
            Table previousTable = dependentTables.get(fkName);
            if (fkTable != previousTable) {
                throw new RuntimeException("Foreign key name (" + fkName + ") mapped to different tables! previous: " + String.valueOf(previousTable) + " current:" + String.valueOf(fkTable));
            }
        }
        Column column = new Column(fkColumnName);
        Column existingColumn = fkTable.getColumn(column);
        if (existingColumn != null) {
            depColumns.add(existingColumn);
        } else {
            depColumns.add(column);
        }
    }

    private void processUserForeignKey(ForeignKey element, Table referencedTable, Map<String, List<Column>> referencedColumns, Map<String, List<Column>> dependentColumns, Map<String, Table> dependentTables) {
        if (!ForeignKeyProcessor.equalTable(referencedTable, element.getReferencedTable(), this.defaultSchema, this.defaultCatalog)) {
            log.debug((Object)("Referenced table " + element.getReferencedTable().getName() + " is not " + String.valueOf(referencedTable) + ". Ignoring userdefined foreign key " + String.valueOf(element)));
            return;
        }
        Table deptable = this.determineDependentTable(dependentTables, element);
        if (deptable == null) {
            log.debug((Object)("User defined foreign key " + element.getName() + " references unknown or filtered table " + String.valueOf(TableIdentifier.create(element.getTable()))));
        } else {
            dependentTables.put(element.getName(), deptable);
            referencedColumns.put(element.getName(), this.getReferencedColums(referencedTable, element));
            dependentColumns.put(element.getName(), this.getDependendColumns(deptable, element));
        }
    }

    private Table determineDependentTable(Map<String, Table> dependentTables, ForeignKey element) {
        Table userfkTable = element.getTable();
        String userfkName = element.getName();
        Table deptable = dependentTables.get(userfkName);
        if (deptable != null) {
            throw new MappingException("Foreign key " + userfkName + " already defined in the database!");
        }
        return this.getTable(ForeignKeyProcessor.getCatalogForDBLookup(userfkTable.getCatalog(), this.defaultCatalog), ForeignKeyProcessor.getSchemaForDBLookup(userfkTable.getSchema(), this.defaultSchema), userfkTable.getName());
    }

    private List<Column> getDependendColumns(Table deptable, ForeignKey element) {
        List userColumns = element.getColumns();
        ArrayList<Column> depColumns = new ArrayList<Column>(userColumns.size());
        for (Column jdbcColumn : userColumns) {
            Column column = new Column(jdbcColumn.getName());
            Column existingColumn = deptable.getColumn(column);
            column = existingColumn == null ? column : existingColumn;
            depColumns.add(column);
        }
        return depColumns;
    }

    private List<Column> getReferencedColums(Table referencedTable, ForeignKey element) {
        List userrefColumns = element.getReferencedColumns();
        ArrayList<Column> result = new ArrayList<Column>(userrefColumns.size());
        for (Column jdbcColumn : userrefColumns) {
            Column column = new Column(jdbcColumn.getName());
            Column existingColumn = referencedTable.getColumn(column);
            column = existingColumn == null ? column : existingColumn;
            result.add(column);
        }
        return result;
    }

    private static String getCatalogForDBLookup(String catalog, String defaultCatalog) {
        return catalog == null ? defaultCatalog : catalog;
    }

    private static String getSchemaForDBLookup(String schema, String defaultSchema) {
        return schema == null ? defaultSchema : schema;
    }

    private static String getCatalogForModel(String catalog, String defaultCatalog) {
        if (catalog == null) {
            return null;
        }
        if (catalog.equals(defaultCatalog)) {
            return null;
        }
        return catalog;
    }

    private static String getSchemaForModel(String schema, String defaultSchema) {
        if (schema == null) {
            return null;
        }
        if (schema.equals(defaultSchema)) {
            return null;
        }
        return schema;
    }

    private static boolean equalTable(Table table1, Table table2, String defaultSchema, String defaultCatalog) {
        return table1.getName().equals(table2.getName()) && StringUtil.isEqual(ForeignKeyProcessor.getSchemaForModel(table1.getSchema(), defaultSchema), ForeignKeyProcessor.getSchemaForModel(table2.getSchema(), defaultSchema)) && StringUtil.isEqual(ForeignKeyProcessor.getCatalogForModel(table1.getCatalog(), defaultCatalog), ForeignKeyProcessor.getCatalogForModel(table2.getCatalog(), defaultCatalog));
    }

    private Table getTable(String catalog, String schema, String name) {
        return this.revengMetadataCollector.getTable(TableIdentifier.create(this.quote(catalog), this.quote(schema), this.quote(name)));
    }

    private String quote(String name) {
        if (name == null) {
            return name;
        }
        if (this.metaDataDialect.needQuote(name)) {
            if (name.length() > 1 && name.charAt(0) == '`' && name.charAt(name.length() - 1) == '`') {
                return name;
            }
            return "`" + name + "`";
        }
        return name;
    }
}

