/*
 * Decompiled with CFR 0.152.
 */
package org.hibersap.execution.jco;

import com.sap.conn.jco.JCoCustomDestination;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoRepository;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibersap.HibersapException;
import org.hibersap.execution.Connection;
import org.hibersap.execution.jco.JCoContextAdapter;
import org.hibersap.execution.jco.JCoContextAdapterImpl;
import org.hibersap.execution.jco.JCoEnvironment;
import org.hibersap.execution.jco.JCoMapper;
import org.hibersap.execution.jco.JCoTransaction;
import org.hibersap.mapping.model.BapiMapping;
import org.hibersap.session.Credentials;
import org.hibersap.session.SessionImplementor;
import org.hibersap.session.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCoConnection
implements Connection {
    private static final Log LOG = LogFactory.getLog(JCoConnection.class);
    private final JCoContextAdapter jcoContext = new JCoContextAdapterImpl();
    private final JCoMapper jcoMapper = new JCoMapper();
    private final String destinationName;
    private JCoDestination destination = null;
    private JCoTransaction transaction = null;
    private Credentials credentials;

    public JCoConnection(String destinationName) {
        this.destinationName = destinationName;
    }

    public Transaction beginTransaction(SessionImplementor session) {
        if (this.transaction != null) {
            return this.transaction;
        }
        this.transaction = new JCoTransaction(session);
        this.transaction.begin();
        return this.transaction;
    }

    public void close() {
        if (this.destination != null) {
            this.endStatefulConnection();
        }
    }

    public void execute(BapiMapping bapiMapping, Map<String, Object> functionMap) {
        JCoFunction function;
        if (this.destination == null) {
            this.startStatefulConnection();
        }
        try {
            function = this.getRepository().getFunction(bapiMapping.getBapiName());
        }
        catch (JCoException e) {
            throw new HibersapException("The function " + bapiMapping.getBapiName() + " is not available in the SAP system", (Throwable)e);
        }
        if (function == null) {
            throw new HibersapException("The function module '" + bapiMapping.getBapiName() + "' does not exist in SAP");
        }
        this.jcoMapper.putFunctionMapValuesToFunction(function, functionMap);
        try {
            function.execute(this.destination);
        }
        catch (JCoException e) {
            throw new HibersapException("Error executing function module " + bapiMapping.getBapiName(), (Throwable)e);
        }
        this.jcoMapper.putFunctionValuesToFunctionMap(function, functionMap);
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    private void copyCredentialsToUserData(Credentials cred, JCoCustomDestination.UserData data) {
        if (this.isNotNull(cred.getAliasUser())) {
            data.setAliasUser(cred.getAliasUser());
        }
        if (this.isNotNull(cred.getClient())) {
            data.setClient(cred.getClient());
        }
        if (this.isNotNull(cred.getLanguage())) {
            data.setLanguage(cred.getLanguage());
        }
        if (this.isNotNull(cred.getPassword())) {
            data.setPassword(cred.getPassword());
        }
        if (this.isNotNull(cred.getSsoTicket())) {
            data.setSSOTicket(cred.getSsoTicket());
        }
        if (this.isNotNull(cred.getUser())) {
            data.setUser(cred.getUser());
        }
        if (this.isNotNull(cred.getX509Certificate())) {
            data.setX509Certificate(cred.getX509Certificate());
        }
    }

    private boolean isNotNull(Object object) {
        return object != null;
    }

    private void endStatefulConnection() {
        try {
            this.jcoContext.end(this.destination);
        }
        catch (JCoException e) {
            LOG.warn((Object)"JCo connection could not be ended, ignoring it for now...", (Throwable)e);
        }
        finally {
            this.destination = null;
        }
    }

    private JCoCustomDestination getCustomDestination(JCoDestination dest, Credentials cred) {
        JCoCustomDestination custDest = dest.createCustomDestination();
        JCoCustomDestination.UserData data = custDest.getUserLogonData();
        this.copyCredentialsToUserData(cred, data);
        return custDest;
    }

    private JCoRepository getRepository() {
        try {
            return this.destination.getRepository();
        }
        catch (JCoException e) {
            throw new HibersapException("Can not get repository from destination " + this.destination.getDestinationName(), (Throwable)e);
        }
    }

    private void startStatefulConnection() {
        this.destination = JCoEnvironment.getDestination(this.destinationName);
        if (this.jcoContext.isStateful(this.destination)) {
            throw new HibersapException("A stateful JCo session was already started for the given destination in the current thread.");
        }
        if (this.credentials != null) {
            this.destination = this.getCustomDestination(this.destination, this.credentials);
        }
        this.jcoContext.begin(this.destination);
    }
}

