/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.fxgson.adapters.properties.primitives;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javafx.beans.property.Property;
import org.hildan.fxgson.adapters.properties.NullPropertyException;
import org.hildan.fxgson.adapters.properties.primitives.NullPrimitiveException;
import org.jetbrains.annotations.NotNull;

public abstract class PrimitivePropertyTypeAdapter<I, P extends Property<?>>
extends TypeAdapter<P> {
    private final TypeAdapter<I> delegate;
    private final boolean throwOnNullProperty;
    private final boolean crashOnNullValue;

    public PrimitivePropertyTypeAdapter(TypeAdapter<I> innerValueTypeAdapter, boolean throwOnNullProperty, boolean crashOnNullValue) {
        this.delegate = innerValueTypeAdapter;
        this.throwOnNullProperty = throwOnNullProperty;
        this.crashOnNullValue = crashOnNullValue;
    }

    public void write(JsonWriter out, P property) throws IOException {
        if (property == null) {
            if (this.throwOnNullProperty) {
                throw new NullPropertyException();
            }
            out.nullValue();
            return;
        }
        this.delegate.write(out, this.extractPrimitiveValue(property));
    }

    public P read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            if (this.crashOnNullValue) {
                throw new NullPrimitiveException(in.getPath());
            }
            return this.createDefaultProperty();
        }
        return this.wrapNonNullPrimitiveValue(this.delegate.read(in));
    }

    @NotNull
    protected abstract I extractPrimitiveValue(P var1);

    @NotNull
    protected abstract P createDefaultProperty();

    @NotNull
    protected abstract P wrapNonNullPrimitiveValue(@NotNull I var1);
}

