/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.AdamsIntegrator;
import org.hipparchus.ode.nonstiff.AdamsStateInterpolator;
import org.hipparchus.ode.nonstiff.StepsizeHelper;
import org.hipparchus.util.FastMath;

public class AdamsBashforthIntegrator
extends AdamsIntegrator {
    private static final String METHOD_NAME = "Adams-Bashforth";

    public AdamsBashforthIntegrator(int nSteps, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) throws MathIllegalArgumentException {
        super(METHOD_NAME, nSteps, nSteps, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
    }

    public AdamsBashforthIntegrator(int nSteps, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) throws IllegalArgumentException {
        super(METHOD_NAME, nSteps, nSteps, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
    }

    @Override
    protected double errorEstimation(double[] previousState, double predictedTime, double[] predictedState, double[] predictedScaled, RealMatrix predictedNordsieck) {
        StepsizeHelper helper = this.getStepSizeHelper();
        double error = 0.0;
        for (int i = 0; i < helper.getMainSetDimension(); ++i) {
            double tol = helper.getTolerance(i, FastMath.abs((double)predictedState[i]));
            double variation = 0.0;
            int sign = predictedNordsieck.getRowDimension() % 2 == 0 ? -1 : 1;
            for (int k = predictedNordsieck.getRowDimension() - 1; k >= 0; --k) {
                variation += (double)sign * predictedNordsieck.getEntry(k, i);
                sign = -sign;
            }
            double ratio = (predictedState[i] - previousState[i] + (variation -= predictedScaled[i])) / tol;
            error += ratio * ratio;
        }
        return FastMath.sqrt((double)(error / (double)helper.getMainSetDimension()));
    }

    @Override
    protected AdamsStateInterpolator finalizeStep(double stepSize, double[] predictedState, double[] predictedScaled, Array2DRowRealMatrix predictedNordsieck, boolean isForward, ODEStateAndDerivative globalPreviousState, ODEStateAndDerivative globalCurrentState, EquationsMapper equationsMapper) {
        return new AdamsStateInterpolator(this.getStepSize(), globalCurrentState, predictedScaled, predictedNordsieck, isForward, this.getStepStart(), globalCurrentState, equationsMapper);
    }
}

