/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.ClassicalRungeKuttaFieldStateInterpolator;
import org.hipparchus.ode.nonstiff.RungeKuttaFieldIntegrator;
import org.hipparchus.util.MathArrays;

public class ClassicalRungeKuttaFieldIntegrator<T extends CalculusFieldElement<T>>
extends RungeKuttaFieldIntegrator<T> {
    public ClassicalRungeKuttaFieldIntegrator(Field<T> field, T step) {
        super(field, "classical Runge-Kutta", step);
    }

    @Override
    public T[] getC() {
        CalculusFieldElement[] c = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)3);
        c[0] = (CalculusFieldElement)((CalculusFieldElement)this.getField().getOne()).multiply(0.5);
        c[1] = c[0];
        c[2] = (CalculusFieldElement)this.getField().getOne();
        return c;
    }

    @Override
    public T[][] getA() {
        CalculusFieldElement[][] a = (CalculusFieldElement[][])MathArrays.buildArray(this.getField(), (int)3, (int)-1);
        for (int i = 0; i < a.length; ++i) {
            a[i] = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)(i + 1));
        }
        a[0][0] = this.fraction(1, 2);
        a[1][0] = (CalculusFieldElement)this.getField().getZero();
        a[1][1] = a[0][0];
        a[2][0] = (CalculusFieldElement)this.getField().getZero();
        a[2][1] = (CalculusFieldElement)this.getField().getZero();
        a[2][2] = (CalculusFieldElement)this.getField().getOne();
        return a;
    }

    @Override
    public T[] getB() {
        CalculusFieldElement[] b = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)4);
        b[0] = this.fraction(1, 6);
        b[1] = this.fraction(1, 3);
        b[2] = b[1];
        b[3] = b[0];
        return b;
    }

    @Override
    protected ClassicalRungeKuttaFieldStateInterpolator<T> createInterpolator(boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldEquationsMapper<T> mapper) {
        return new ClassicalRungeKuttaFieldStateInterpolator(this.getField(), forward, yDotK, globalPreviousState, globalCurrentState, globalPreviousState, globalCurrentState, mapper);
    }
}

