/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.EmbeddedRungeKuttaFieldIntegrator;
import org.hipparchus.ode.nonstiff.HighamHall54FieldStateInterpolator;
import org.hipparchus.ode.nonstiff.HighamHall54Integrator;
import org.hipparchus.ode.nonstiff.StepsizeHelper;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public class HighamHall54FieldIntegrator<T extends CalculusFieldElement<T>>
extends EmbeddedRungeKuttaFieldIntegrator<T> {
    public HighamHall54FieldIntegrator(Field<T> field, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        super(field, "Higham-Hall 5(4)", -1, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
    }

    public HighamHall54FieldIntegrator(Field<T> field, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(field, "Higham-Hall 5(4)", -1, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
    }

    @Override
    public T[] getC() {
        CalculusFieldElement[] c = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)6);
        c[0] = this.fraction(2, 9);
        c[1] = this.fraction(1, 3);
        c[2] = this.fraction(1, 2);
        c[3] = this.fraction(3, 5);
        c[4] = (CalculusFieldElement)this.getField().getOne();
        c[5] = (CalculusFieldElement)this.getField().getOne();
        return c;
    }

    @Override
    public T[][] getA() {
        CalculusFieldElement[][] a = (CalculusFieldElement[][])MathArrays.buildArray(this.getField(), (int)6, (int)-1);
        for (int i = 0; i < a.length; ++i) {
            a[i] = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)(i + 1));
        }
        a[0][0] = this.fraction(2, 9);
        a[1][0] = this.fraction(1, 12);
        a[1][1] = this.fraction(1, 4);
        a[2][0] = this.fraction(1, 8);
        a[2][1] = (CalculusFieldElement)this.getField().getZero();
        a[2][2] = this.fraction(3, 8);
        a[3][0] = this.fraction(91, 500);
        a[3][1] = this.fraction(-27, 100);
        a[3][2] = this.fraction(78, 125);
        a[3][3] = this.fraction(8, 125);
        a[4][0] = this.fraction(-11, 20);
        a[4][1] = this.fraction(27, 20);
        a[4][2] = this.fraction(12, 5);
        a[4][3] = this.fraction(-36, 5);
        a[4][4] = this.fraction(5, 1);
        a[5][0] = this.fraction(1, 12);
        a[5][1] = (CalculusFieldElement)this.getField().getZero();
        a[5][2] = this.fraction(27, 32);
        a[5][3] = this.fraction(-4, 3);
        a[5][4] = this.fraction(125, 96);
        a[5][5] = this.fraction(5, 48);
        return a;
    }

    @Override
    public T[] getB() {
        CalculusFieldElement[] b = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)7);
        b[0] = this.fraction(1, 12);
        b[1] = (CalculusFieldElement)this.getField().getZero();
        b[2] = this.fraction(27, 32);
        b[3] = this.fraction(-4, 3);
        b[4] = this.fraction(125, 96);
        b[5] = this.fraction(5, 48);
        b[6] = (CalculusFieldElement)this.getField().getZero();
        return b;
    }

    @Override
    protected HighamHall54FieldStateInterpolator<T> createInterpolator(boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldEquationsMapper<T> mapper) {
        return new HighamHall54FieldStateInterpolator(this.getField(), forward, yDotK, globalPreviousState, globalCurrentState, globalPreviousState, globalCurrentState, mapper);
    }

    @Override
    public int getOrder() {
        return 5;
    }

    @Override
    protected double estimateError(T[][] yDotK, T[] y0, T[] y1, T h) {
        StepsizeHelper helper = this.getStepSizeHelper();
        double error = 0.0;
        for (int j = 0; j < helper.getMainSetDimension(); ++j) {
            double errSum = HighamHall54Integrator.STATIC_E[0] * yDotK[0][j].getReal();
            for (int l = 1; l < HighamHall54Integrator.STATIC_E.length; ++l) {
                errSum += HighamHall54Integrator.STATIC_E[l] * yDotK[l][j].getReal();
            }
            double tol = helper.getTolerance(j, FastMath.max((double)FastMath.abs((double)y0[j].getReal()), (double)FastMath.abs((double)y1[j].getReal())));
            double ratio = h.getReal() * errSum / tol;
            error += ratio * ratio;
        }
        return FastMath.sqrt((double)(error / (double)helper.getMainSetDimension()));
    }
}

