/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.RungeKuttaStateInterpolator;
import org.hipparchus.util.FastMath;

class LutherStateInterpolator
extends RungeKuttaStateInterpolator {
    private static final long serialVersionUID = 20160328L;
    private static final double Q = FastMath.sqrt((double)21.0);

    LutherStateInterpolator(boolean forward, double[][] yDotK, ODEStateAndDerivative globalPreviousState, ODEStateAndDerivative globalCurrentState, ODEStateAndDerivative softPreviousState, ODEStateAndDerivative softCurrentState, EquationsMapper mapper) {
        super(forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
    }

    @Override
    protected LutherStateInterpolator create(boolean newForward, double[][] newYDotK, ODEStateAndDerivative newGlobalPreviousState, ODEStateAndDerivative newGlobalCurrentState, ODEStateAndDerivative newSoftPreviousState, ODEStateAndDerivative newSoftCurrentState, EquationsMapper newMapper) {
        return new LutherStateInterpolator(newForward, newYDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected ODEStateAndDerivative computeInterpolatedStateAndDerivatives(EquationsMapper mapper, double time, double theta, double thetaH, double oneMinusThetaH) {
        double[] interpolatedDerivatives;
        double[] interpolatedState;
        double coeffDot1 = 1.0 + theta * (-10.8 + theta * (36.0 + theta * (-47.0 + theta * 21.0)));
        double coeffDot2 = 0.0;
        double coeffDot3 = theta * (-13.866666666666667 + theta * (106.66666666666667 + theta * (-202.66666666666666 + theta * 112.0)));
        double coeffDot4 = theta * (12.96 + theta * (-97.2 + theta * (194.4 + theta * -567.0 / 5.0)));
        double coeffDot5 = theta * ((833.0 + 343.0 * Q) / 150.0 + theta * ((-637.0 - 357.0 * Q) / 30.0 + theta * ((392.0 + 287.0 * Q) / 15.0 + theta * (-49.0 - 49.0 * Q) / 5.0)));
        double coeffDot6 = theta * ((833.0 - 343.0 * Q) / 150.0 + theta * ((-637.0 + 357.0 * Q) / 30.0 + theta * ((392.0 - 287.0 * Q) / 15.0 + theta * (-49.0 + 49.0 * Q) / 5.0)));
        double coeffDot7 = theta * (0.6 + theta * (-3.0 + theta * 3.0));
        if (this.getGlobalPreviousState() != null && theta <= 0.5) {
            double coeff1 = 1.0 + theta * (-5.4 + theta * (12.0 + theta * (-11.75 + theta * 21.0 / 5.0)));
            double coeff2 = 0.0;
            double coeff3 = theta * (-6.933333333333334 + theta * (35.55555555555556 + theta * (-50.666666666666664 + theta * 112.0 / 5.0)));
            double coeff4 = theta * (6.48 + theta * (-32.4 + theta * (48.6 + theta * -567.0 / 25.0)));
            double coeff5 = theta * ((833.0 + 343.0 * Q) / 300.0 + theta * ((-637.0 - 357.0 * Q) / 90.0 + theta * ((392.0 + 287.0 * Q) / 60.0 + theta * (-49.0 - 49.0 * Q) / 25.0)));
            double coeff6 = theta * ((833.0 - 343.0 * Q) / 300.0 + theta * ((-637.0 + 357.0 * Q) / 90.0 + theta * ((392.0 - 287.0 * Q) / 60.0 + theta * (-49.0 + 49.0 * Q) / 25.0)));
            double coeff7 = theta * (0.3 + theta * (-1.0 + theta * 0.75));
            interpolatedState = this.previousStateLinearCombination(thetaH * coeff1, thetaH * 0.0, thetaH * coeff3, thetaH * coeff4, thetaH * coeff5, thetaH * coeff6, thetaH * coeff7);
            interpolatedDerivatives = this.derivativeLinearCombination(coeffDot1, 0.0, coeffDot3, coeffDot4, coeffDot5, coeffDot6, coeffDot7);
        } else {
            double coeff1 = -0.05 + theta * (0.95 + theta * (-4.45 + theta * (7.55 + theta * -21.0 / 5.0)));
            double coeff2 = 0.0;
            double coeff3 = -0.35555555555555557 + theta * (-0.35555555555555557 + theta * (-7.288888888888889 + theta * (28.266666666666666 + theta * -112.0 / 5.0)));
            double coeff4 = theta * (theta * (6.48 + theta * (-25.92 + theta * 567.0 / 25.0)));
            double coeff5 = -0.2722222222222222 + theta * (-0.2722222222222222 + theta * ((2254.0 + 1029.0 * Q) / 900.0 + theta * ((-1372.0 - 847.0 * Q) / 300.0 + theta * (49.0 + 49.0 * Q) / 25.0)));
            double coeff6 = -0.2722222222222222 + theta * (-0.2722222222222222 + theta * ((2254.0 - 1029.0 * Q) / 900.0 + theta * ((-1372.0 + 847.0 * Q) / 300.0 + theta * (49.0 - 49.0 * Q) / 25.0)));
            double coeff7 = -0.05 + theta * (-0.05 + theta * (0.25 + theta * -0.75));
            interpolatedState = this.currentStateLinearCombination(oneMinusThetaH * coeff1, oneMinusThetaH * 0.0, oneMinusThetaH * coeff3, oneMinusThetaH * coeff4, oneMinusThetaH * coeff5, oneMinusThetaH * coeff6, oneMinusThetaH * coeff7);
            interpolatedDerivatives = this.derivativeLinearCombination(coeffDot1, 0.0, coeffDot3, coeffDot4, coeffDot5, coeffDot6, coeffDot7);
        }
        return mapper.mapStateAndDerivative(time, interpolatedState, interpolatedDerivatives);
    }
}

