/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.MidpointFieldStateInterpolator;
import org.hipparchus.ode.nonstiff.RungeKuttaFieldIntegrator;
import org.hipparchus.util.MathArrays;

public class MidpointFieldIntegrator<T extends CalculusFieldElement<T>>
extends RungeKuttaFieldIntegrator<T> {
    public MidpointFieldIntegrator(Field<T> field, T step) {
        super(field, "midpoint", step);
    }

    @Override
    public T[] getC() {
        CalculusFieldElement[] c = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)1);
        c[0] = (CalculusFieldElement)((CalculusFieldElement)this.getField().getOne()).multiply(0.5);
        return c;
    }

    @Override
    public T[][] getA() {
        CalculusFieldElement[][] a = (CalculusFieldElement[][])MathArrays.buildArray(this.getField(), (int)1, (int)1);
        a[0][0] = this.fraction(1, 2);
        return a;
    }

    @Override
    public T[] getB() {
        CalculusFieldElement[] b = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)2);
        b[0] = (CalculusFieldElement)this.getField().getZero();
        b[1] = (CalculusFieldElement)this.getField().getOne();
        return b;
    }

    @Override
    protected MidpointFieldStateInterpolator<T> createInterpolator(boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldEquationsMapper<T> mapper) {
        return new MidpointFieldStateInterpolator(this.getField(), forward, yDotK, globalPreviousState, globalCurrentState, globalPreviousState, globalCurrentState, mapper);
    }
}

