/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.RungeKuttaFieldIntegrator;
import org.hipparchus.ode.nonstiff.ThreeEighthesFieldStateInterpolator;
import org.hipparchus.util.MathArrays;

public class ThreeEighthesFieldIntegrator<T extends CalculusFieldElement<T>>
extends RungeKuttaFieldIntegrator<T> {
    public ThreeEighthesFieldIntegrator(Field<T> field, T step) {
        super(field, "3/8", step);
    }

    @Override
    public T[] getC() {
        CalculusFieldElement[] c = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)3);
        c[0] = this.fraction(1, 3);
        c[1] = (CalculusFieldElement)c[0].add((FieldElement)c[0]);
        c[2] = (CalculusFieldElement)this.getField().getOne();
        return c;
    }

    @Override
    public T[][] getA() {
        CalculusFieldElement[][] a = (CalculusFieldElement[][])MathArrays.buildArray(this.getField(), (int)3, (int)-1);
        for (int i = 0; i < a.length; ++i) {
            a[i] = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)(i + 1));
        }
        a[0][0] = this.fraction(1, 3);
        a[1][0] = (CalculusFieldElement)a[0][0].negate();
        a[1][1] = (CalculusFieldElement)this.getField().getOne();
        a[2][0] = (CalculusFieldElement)this.getField().getOne();
        a[2][1] = (CalculusFieldElement)((CalculusFieldElement)this.getField().getOne()).negate();
        a[2][2] = (CalculusFieldElement)this.getField().getOne();
        return a;
    }

    @Override
    public T[] getB() {
        CalculusFieldElement[] b = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)4);
        b[0] = this.fraction(1, 8);
        b[1] = this.fraction(3, 8);
        b[2] = b[1];
        b[3] = b[0];
        return b;
    }

    @Override
    protected ThreeEighthesFieldStateInterpolator<T> createInterpolator(boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldEquationsMapper<T> mapper) {
        return new ThreeEighthesFieldStateInterpolator(this.getField(), forward, yDotK, globalPreviousState, globalCurrentState, globalPreviousState, globalCurrentState, mapper);
    }
}

