/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive;

import java.util.Arrays;
import org.hipparchus.stat.descriptive.StatisticalSummaryValues;
import org.hipparchus.util.MathUtils;

public interface StatisticalSummary {
    public static StatisticalSummary aggregate(StatisticalSummary ... statistics) {
        MathUtils.checkNotNull((Object)statistics);
        return StatisticalSummary.aggregate(Arrays.asList(statistics));
    }

    public static StatisticalSummary aggregate(Iterable<? extends StatisticalSummary> statistics) {
        MathUtils.checkNotNull(statistics);
        long n = 0L;
        double min = Double.NaN;
        double max = Double.NaN;
        double sum = Double.NaN;
        double mean = Double.NaN;
        double m2 = Double.NaN;
        for (StatisticalSummary statisticalSummary : statistics) {
            if (statisticalSummary.getN() == 0L) continue;
            if (n == 0L) {
                n = statisticalSummary.getN();
                min = statisticalSummary.getMin();
                sum = statisticalSummary.getSum();
                max = statisticalSummary.getMax();
                m2 = statisticalSummary.getVariance() * (double)(n - 1L);
                mean = statisticalSummary.getMean();
                continue;
            }
            if (statisticalSummary.getMin() < min) {
                min = statisticalSummary.getMin();
            }
            if (statisticalSummary.getMax() > max) {
                max = statisticalSummary.getMax();
            }
            double oldN = n;
            double curN = statisticalSummary.getN();
            n = (long)((double)n + curN);
            double meanDiff = statisticalSummary.getMean() - mean;
            mean = (sum += statisticalSummary.getSum()) / (double)n;
            double curM2 = statisticalSummary.getVariance() * (curN - 1.0);
            m2 = m2 + curM2 + meanDiff * meanDiff * oldN * curN / (double)n;
        }
        double variance = n == 0L ? Double.NaN : (n == 1L ? 0.0 : m2 / (double)(n - 1L));
        return new StatisticalSummaryValues(mean, variance, n, max, min, sum);
    }

    public double getMean();

    public double getVariance();

    public double getStandardDeviation();

    public double getMax();

    public double getMin();

    public long getN();

    public double getSum();
}

