/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.moment;

import java.io.Serializable;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.hipparchus.util.MathUtils;

class FirstMoment
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 20150412L;
    protected long n;
    protected double m1;
    protected double dev;
    protected double nDev;

    FirstMoment() {
        this.n = 0L;
        this.m1 = Double.NaN;
        this.dev = Double.NaN;
        this.nDev = Double.NaN;
    }

    FirstMoment(FirstMoment original) throws NullArgumentException {
        MathUtils.checkNotNull((Object)original);
        this.n = original.n;
        this.m1 = original.m1;
        this.dev = original.dev;
        this.nDev = original.nDev;
    }

    @Override
    public void increment(double d) {
        if (this.n == 0L) {
            this.m1 = 0.0;
        }
        ++this.n;
        double n0 = this.n;
        this.dev = d - this.m1;
        this.nDev = this.dev / n0;
        this.m1 += this.nDev;
    }

    @Override
    public void clear() {
        this.m1 = Double.NaN;
        this.n = 0L;
        this.dev = Double.NaN;
        this.nDev = Double.NaN;
    }

    @Override
    public double getResult() {
        return this.m1;
    }

    @Override
    public long getN() {
        return this.n;
    }

    protected void aggregate(FirstMoment other) {
        MathUtils.checkNotNull((Object)other);
        if (other.n > 0L) {
            if (this.n == 0L) {
                this.m1 = 0.0;
            }
            this.n += other.n;
            this.dev = other.m1 - this.m1;
            this.nDev = this.dev / (double)this.n;
            this.m1 += (double)other.n / (double)this.n * this.dev;
        }
    }

    @Override
    public FirstMoment copy() {
        return new FirstMoment(this);
    }
}

