/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.projection;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.linear.EigenDecompositionSymmetric;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.stat.LocalizedStatFormats;
import org.hipparchus.stat.StatUtils;
import org.hipparchus.stat.correlation.Covariance;
import org.hipparchus.stat.descriptive.moment.StandardDeviation;

public class PCA {
    private final int numC;
    private final boolean scale;
    private final boolean biasCorrection;
    private double[] center;
    private double[] std;
    private double[] eigenValues;
    private RealMatrix principalComponents;
    private final StandardDeviation sd;

    public PCA(int numC, boolean scale, boolean biasCorrection) {
        this.numC = numC;
        this.scale = scale;
        this.biasCorrection = biasCorrection;
        this.sd = scale ? new StandardDeviation(biasCorrection) : null;
    }

    public PCA(int numC) {
        this(numC, false, true);
    }

    public int getNumComponents() {
        return this.numC;
    }

    public boolean isScale() {
        return this.scale;
    }

    public boolean isBiasCorrection() {
        return this.biasCorrection;
    }

    public double[] getVariance() {
        this.validateState("getVariance");
        return (double[])this.eigenValues.clone();
    }

    public double[] getCenter() {
        this.validateState("getCenter");
        return (double[])this.center.clone();
    }

    public double[][] getComponents() {
        this.validateState("getComponents");
        return this.principalComponents.getData();
    }

    public double[][] fitAndTransform(double[][] data) {
        this.center = null;
        RealMatrix normalizedM = this.getNormalizedMatrix(data);
        this.calculatePrincipalComponents(normalizedM);
        return normalizedM.multiply(this.principalComponents).getData();
    }

    public double[][] transform(double[][] data) {
        this.validateState("transform");
        RealMatrix normalizedM = this.getNormalizedMatrix(data);
        return normalizedM.multiply(this.principalComponents).getData();
    }

    public PCA fit(double[][] data) {
        this.center = null;
        RealMatrix normalized = this.getNormalizedMatrix(data);
        this.calculatePrincipalComponents(normalized);
        return this;
    }

    private void validateState(String from) {
        if (this.center == null) {
            throw new MathIllegalStateException((Localizable)LocalizedStatFormats.ILLEGAL_STATE_PCA, new Object[]{from});
        }
    }

    private void calculatePrincipalComponents(RealMatrix normalizedM) {
        RealMatrix covarianceM = new Covariance(normalizedM).getCovarianceMatrix();
        EigenDecompositionSymmetric decomposition = new EigenDecompositionSymmetric(covarianceM);
        this.eigenValues = decomposition.getEigenvalues();
        this.principalComponents = MatrixUtils.createRealMatrix((int)this.eigenValues.length, (int)this.numC);
        for (int c = 0; c < this.numC; ++c) {
            for (int f = 0; f < this.eigenValues.length; ++f) {
                this.principalComponents.setEntry(f, c, decomposition.getEigenvector(c).getEntry(f));
            }
        }
    }

    private RealMatrix getNormalizedMatrix(double[][] input) {
        boolean calculating;
        int numS = input.length;
        int numF = input[0].length;
        boolean bl = calculating = this.center == null;
        if (calculating) {
            this.center = new double[numF];
            if (this.scale) {
                this.std = new double[numF];
            }
        }
        double[][] normalized = new double[numS][numF];
        for (int f = 0; f < numF; ++f) {
            int s;
            if (calculating) {
                this.calculateNormalizeParameters(input, numS, f);
            }
            for (s = 0; s < numS; ++s) {
                normalized[s][f] = input[s][f] - this.center[f];
            }
            if (!this.scale) continue;
            for (s = 0; s < numS; ++s) {
                double[] dArray = normalized[s];
                int n = f;
                dArray[n] = dArray[n] / this.std[f];
            }
        }
        return MatrixUtils.createRealMatrix((double[][])normalized);
    }

    private void calculateNormalizeParameters(double[][] input, int numS, int f) {
        double[] column = new double[numS];
        for (int s = 0; s < numS; ++s) {
            column[s] = input[s][f];
        }
        this.center[f] = StatUtils.mean(column);
        if (this.scale) {
            this.std[f] = this.sd.evaluate(column, this.center[f]);
        }
    }
}

