/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.fitting;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.hipparchus.distribution.RealDistribution;
import org.hipparchus.distribution.continuous.AbstractRealDistribution;
import org.hipparchus.distribution.continuous.ConstantRealDistribution;
import org.hipparchus.distribution.continuous.NormalDistribution;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.random.RandomDataGenerator;
import org.hipparchus.random.RandomGenerator;
import org.hipparchus.stat.descriptive.StatisticalSummary;
import org.hipparchus.stat.descriptive.StreamingStatistics;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public class EmpiricalDistribution
extends AbstractRealDistribution {
    public static final int DEFAULT_BIN_COUNT = 1000;
    private static final String FILE_CHARSET = "US-ASCII";
    private static final long serialVersionUID = 5729073523949762654L;
    protected final RandomDataGenerator randomData;
    private final List<StreamingStatistics> binStats;
    private StreamingStatistics sampleStats;
    private double max = Double.NEGATIVE_INFINITY;
    private double min = Double.POSITIVE_INFINITY;
    private double delta;
    private final int binCount;
    private boolean loaded;
    private double[] upperBounds;

    public EmpiricalDistribution() {
        this(1000);
    }

    public EmpiricalDistribution(int binCount) {
        this(binCount, new RandomDataGenerator());
    }

    public EmpiricalDistribution(int binCount, RandomGenerator generator) {
        this(binCount, RandomDataGenerator.of((RandomGenerator)generator));
    }

    public EmpiricalDistribution(RandomGenerator generator) {
        this(1000, generator);
    }

    private EmpiricalDistribution(int binCount, RandomDataGenerator randomData) {
        if (binCount <= 0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_SMALL_BOUND_EXCLUDED, new Object[]{binCount, 0});
        }
        this.binCount = binCount;
        this.randomData = randomData;
        this.binStats = new ArrayList<StreamingStatistics>();
    }

    public void load(double[] in) throws NullArgumentException {
        try (ArrayDataAdapter da = new ArrayDataAdapter(in);){
            ((DataAdapter)da).computeStats();
            this.fillBinStats(new ArrayDataAdapter(in));
        }
        catch (IOException ex) {
            throw MathRuntimeException.createInternalError();
        }
        this.loaded = true;
    }

    public void load(URL url) throws IOException, MathIllegalArgumentException, NullArgumentException {
        MathUtils.checkNotNull((Object)url);
        Charset charset = Charset.forName(FILE_CHARSET);
        try (InputStream is1 = url.openStream();
             InputStreamReader isr1 = new InputStreamReader(is1, charset);
             BufferedReader br1 = new BufferedReader(isr1);
             StreamDataAdapter da1 = new StreamDataAdapter(br1);){
            ((DataAdapter)da1).computeStats();
            if (this.sampleStats.getN() == 0L) {
                throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.URL_CONTAINS_NO_DATA, new Object[]{url});
            }
            try (InputStream is2 = url.openStream();
                 InputStreamReader isr2 = new InputStreamReader(is2, charset);
                 BufferedReader br2 = new BufferedReader(isr2);
                 StreamDataAdapter da2 = new StreamDataAdapter(br2);){
                this.fillBinStats(da2);
                this.loaded = true;
            }
        }
    }

    public void load(File file) throws IOException, NullArgumentException {
        MathUtils.checkNotNull((Object)file);
        Charset charset = Charset.forName(FILE_CHARSET);
        try (InputStream is1 = Files.newInputStream(file.toPath(), new OpenOption[0]);
             BufferedReader br1 = new BufferedReader(new InputStreamReader(is1, charset));
             StreamDataAdapter da1 = new StreamDataAdapter(br1);){
            ((DataAdapter)da1).computeStats();
            try (InputStream is2 = Files.newInputStream(file.toPath(), new OpenOption[0]);
                 BufferedReader in2 = new BufferedReader(new InputStreamReader(is2, charset));
                 StreamDataAdapter da2 = new StreamDataAdapter(in2);){
                this.fillBinStats(da2);
            }
            this.loaded = true;
        }
    }

    private void fillBinStats(DataAdapter da) throws IOException {
        int i;
        this.min = this.sampleStats.getMin();
        this.max = this.sampleStats.getMax();
        this.delta = (this.max - this.min) / (double)this.binCount;
        if (!this.binStats.isEmpty()) {
            this.binStats.clear();
        }
        for (i = 0; i < this.binCount; ++i) {
            StreamingStatistics stats = new StreamingStatistics();
            this.binStats.add(i, stats);
        }
        da.computeBinStats();
        this.upperBounds = new double[this.binCount];
        this.upperBounds[0] = (double)this.binStats.get(0).getN() / (double)this.sampleStats.getN();
        for (i = 1; i < this.binCount - 1; ++i) {
            this.upperBounds[i] = this.upperBounds[i - 1] + (double)this.binStats.get(i).getN() / (double)this.sampleStats.getN();
        }
        this.upperBounds[this.binCount - 1] = 1.0;
    }

    private int findBin(double value) {
        return FastMath.min((int)FastMath.max((int)((int)FastMath.ceil((double)((value - this.min) / this.delta)) - 1), (int)0), (int)(this.binCount - 1));
    }

    public double getNextValue() throws MathIllegalStateException {
        if (!this.loaded) {
            throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.DISTRIBUTION_NOT_LOADED, new Object[0]);
        }
        return this.inverseCumulativeProbability(this.randomData.nextDouble());
    }

    public StatisticalSummary getSampleStats() {
        return this.sampleStats;
    }

    public int getBinCount() {
        return this.binCount;
    }

    public List<StreamingStatistics> getBinStats() {
        return this.binStats;
    }

    public double[] getUpperBounds() {
        double[] binUpperBounds = new double[this.binCount];
        for (int i = 0; i < this.binCount - 1; ++i) {
            binUpperBounds[i] = this.min + this.delta * (double)(i + 1);
        }
        binUpperBounds[this.binCount - 1] = this.max;
        return binUpperBounds;
    }

    public double[] getGeneratorUpperBounds() {
        int len = this.upperBounds.length;
        double[] out = new double[len];
        System.arraycopy(this.upperBounds, 0, out, 0, len);
        return out;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void reSeed(long seed) {
        this.randomData.setSeed(seed);
    }

    public double density(double x) {
        if (x < this.min || x > this.max) {
            return 0.0;
        }
        int binIndex = this.findBin(x);
        RealDistribution kernel = this.getKernel(this.binStats.get(binIndex));
        double kernelDensity = kernel.density(x);
        if (kernelDensity == 0.0) {
            return 0.0;
        }
        return kernelDensity * this.pB(binIndex) / this.kB(binIndex);
    }

    public double cumulativeProbability(double x) {
        if (x < this.min) {
            return 0.0;
        }
        if (x >= this.max) {
            return 1.0;
        }
        int binIndex = this.findBin(x);
        double pBminus = this.pBminus(binIndex);
        double pB = this.pB(binIndex);
        RealDistribution kernel = this.k(x);
        if (kernel instanceof ConstantRealDistribution) {
            if (x < kernel.getNumericalMean()) {
                return pBminus;
            }
            return pBminus + pB;
        }
        double[] binBounds = this.getUpperBounds();
        double kB = this.kB(binIndex);
        double lower = binIndex == 0 ? this.min : binBounds[binIndex - 1];
        double withinBinCum = (kernel.cumulativeProbability(x) - kernel.cumulativeProbability(lower)) / kB;
        return pBminus + pB * withinBinCum;
    }

    public double inverseCumulativeProbability(double p) throws MathIllegalArgumentException {
        MathUtils.checkRangeInclusive((double)p, (double)0.0, (double)1.0);
        if (p == 0.0) {
            return this.getSupportLowerBound();
        }
        if (p == 1.0) {
            return this.getSupportUpperBound();
        }
        int i = 0;
        while (this.cumBinP(i) < p) {
            ++i;
        }
        RealDistribution kernel = this.getKernel(this.binStats.get(i));
        double kB = this.kB(i);
        double[] binBounds = this.getUpperBounds();
        double lower = i == 0 ? this.min : binBounds[i - 1];
        double kBminus = kernel.cumulativeProbability(lower);
        double pB = this.pB(i);
        double pBminus = this.pBminus(i);
        double pCrit = p - pBminus;
        if (pCrit <= 0.0) {
            return lower;
        }
        return kernel.inverseCumulativeProbability(kBminus + pCrit * kB / pB);
    }

    public double getNumericalMean() {
        return this.sampleStats.getMean();
    }

    public double getNumericalVariance() {
        return this.sampleStats.getVariance();
    }

    public double getSupportLowerBound() {
        return this.min;
    }

    public double getSupportUpperBound() {
        return this.max;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public void reseedRandomGenerator(long seed) {
        this.randomData.setSeed(seed);
    }

    private double pB(int i) {
        return i == 0 ? this.upperBounds[0] : this.upperBounds[i] - this.upperBounds[i - 1];
    }

    private double pBminus(int i) {
        return i == 0 ? 0.0 : this.upperBounds[i - 1];
    }

    private double kB(int i) {
        double[] binBounds = this.getUpperBounds();
        RealDistribution kernel = this.getKernel(this.binStats.get(i));
        return i == 0 ? kernel.probability(this.min, binBounds[0]) : kernel.probability(binBounds[i - 1], binBounds[i]);
    }

    private RealDistribution k(double x) {
        int binIndex = this.findBin(x);
        return this.getKernel(this.binStats.get(binIndex));
    }

    private double cumBinP(int binIndex) {
        return this.upperBounds[binIndex];
    }

    protected RealDistribution getKernel(StreamingStatistics bStats) {
        if (bStats.getN() < 2L || bStats.getVariance() == 0.0) {
            return new ConstantRealDistribution(bStats.getMean());
        }
        return new NormalDistribution(bStats.getMean(), bStats.getStandardDeviation());
    }

    private class ArrayDataAdapter
    extends DataAdapter {
        private final double[] inputArray;

        ArrayDataAdapter(double[] in) throws NullArgumentException {
            MathUtils.checkNotNull((Object)in);
            this.inputArray = in;
        }

        @Override
        public void computeStats() {
            EmpiricalDistribution.this.sampleStats = new StreamingStatistics();
            for (int i = 0; i < this.inputArray.length; ++i) {
                EmpiricalDistribution.this.sampleStats.addValue(this.inputArray[i]);
            }
        }

        @Override
        public void computeBinStats() {
            for (int i = 0; i < this.inputArray.length; ++i) {
                StreamingStatistics stats = (StreamingStatistics)EmpiricalDistribution.this.binStats.get(EmpiricalDistribution.this.findBin(this.inputArray[i]));
                stats.addValue(this.inputArray[i]);
            }
        }

        @Override
        public void close() {
        }
    }

    private abstract class DataAdapter
    implements Closeable {
        private DataAdapter() {
        }

        public abstract void computeBinStats() throws IOException;

        public abstract void computeStats() throws IOException;
    }

    private class StreamDataAdapter
    extends DataAdapter {
        private BufferedReader inputStream;

        StreamDataAdapter(BufferedReader in) {
            this.inputStream = in;
        }

        @Override
        public void computeBinStats() throws IOException {
            String str = this.inputStream.readLine();
            while (str != null) {
                double val = Double.parseDouble(str);
                StreamingStatistics stats = (StreamingStatistics)EmpiricalDistribution.this.binStats.get(EmpiricalDistribution.this.findBin(val));
                stats.addValue(val);
                str = this.inputStream.readLine();
            }
        }

        @Override
        public void computeStats() throws IOException {
            EmpiricalDistribution.this.sampleStats = new StreamingStatistics();
            String str = this.inputStream.readLine();
            while (str != null) {
                double val = Double.parseDouble(str);
                EmpiricalDistribution.this.sampleStats.addValue(val);
                str = this.inputStream.readLine();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
    }
}

