/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.integration.sdk.internal.operation;

import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.hisp.dhis.integration.sdk.api.Dhis2Response;
import org.hisp.dhis.integration.sdk.api.converter.ConverterFactory;
import org.hisp.dhis.integration.sdk.api.operation.ResourceOperation;
import org.hisp.dhis.integration.sdk.internal.operation.AbstractOperation;

public abstract class AbstractResourceOperation
extends AbstractOperation<Dhis2Response>
implements ResourceOperation {
    protected Object resource;

    public AbstractResourceOperation(String baseApiUrl, String path, OkHttpClient httpClient, ConverterFactory converterFactory, String ... pathParams) {
        super(baseApiUrl, path, httpClient, converterFactory, pathParams);
    }

    @Override
    public Dhis2Response doTransfer(HttpUrl httpUrl) {
        HttpUrl.Builder httpUrlBuilder = httpUrl.newBuilder();
        Request.Builder requestBuilder = new Request.Builder().url(httpUrlBuilder.build()).addHeader("Content-Type", "application/json");
        byte[] bytes = this.resource != null ? (this.resource instanceof String ? ((String)this.resource).getBytes() : this.converterFactory.createRequestConverter(this.resource.getClass()).convert(this.resource).getBytes()) : new byte[]{};
        return this.doResourceTransfer(bytes, requestBuilder);
    }

    protected abstract Dhis2Response doResourceTransfer(byte[] var1, Request.Builder var2);

    @Override
    public ResourceOperation withResource(Object resource) {
        this.resource = resource;
        return this;
    }
}

