/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_39_1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Comparison {
    NULL("NULL"),
    NOT_NULL("NOT_NULL"),
    EMPTY("EMPTY"),
    NOT_EMPTY("NOT_EMPTY"),
    IN("IN"),
    NOT_IN("NOT_IN"),
    EQUAL("EQUAL"),
    NOT_EQUAL("NOT_EQUAL"),
    LESS_THAN("LESS_THAN"),
    LESS_THAN_OR_EQUAL("LESS_THAN_OR_EQUAL"),
    GREATER_THAN("GREATER_THAN"),
    GREATER_THAN_OR_EQUAL("GREATER_THAN_OR_EQUAL"),
    LIKE("LIKE"),
    NOT_LIKE("NOT_LIKE"),
    STARTS_LIKE("STARTS_LIKE"),
    NOT_STARTS_LIKE("NOT_STARTS_LIKE"),
    ENDS_LIKE("ENDS_LIKE"),
    NOT_ENDS_LIKE("NOT_ENDS_LIKE"),
    IEQ("IEQ"),
    ILIKE("ILIKE"),
    NOT_ILIKE("NOT_ILIKE"),
    STARTS_WITH("STARTS_WITH"),
    NOT_STARTS_WITH("NOT_STARTS_WITH"),
    ENDS_WITH("ENDS_WITH"),
    NOT_ENDS_WITH("NOT_ENDS_WITH");

    private final String value;
    private static final Map<String, Comparison> CONSTANTS;

    private Comparison(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static Comparison fromValue(String value) {
        Comparison constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, Comparison>();
        for (Comparison c : Comparison.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

