/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_39_1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Duration {
    P_1_D("P1D"),
    P_7_D("P7D"),
    P_14_D("P14D"),
    P_1_M("P1M"),
    P_2_M("P2M"),
    P_3_M("P3M"),
    P_6_M("P6M"),
    P_1_Y("P1Y");

    private final String value;
    private static final Map<String, Duration> CONSTANTS;

    private Duration(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static Duration fromValue(String value) {
        Duration constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, Duration>();
        for (Duration c : Duration.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

