/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v40_2_2;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hisp.dhis.api.model.v40_2_2.DataValueCategoryDto;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"attribute", "attributeOptionCombo", "categoryOptionCombo", "dataElement", "followup", "orgUnit", "period"})
public class DataValueFollowUpRequest
implements Serializable {
    @JsonProperty(value="attribute")
    private DataValueCategoryDto attribute;
    @JsonProperty(value="attributeOptionCombo")
    @JsonPropertyDescription(value="A UID for an CategoryOptionCombo object  \n(Java name `org.hisp.dhis.category.CategoryOptionCombo`)")
    private String attributeOptionCombo;
    @JsonProperty(value="categoryOptionCombo")
    @JsonPropertyDescription(value="A UID for an CategoryOptionCombo object  \n(Java name `org.hisp.dhis.category.CategoryOptionCombo`)")
    private String categoryOptionCombo;
    @JsonProperty(value="dataElement")
    @JsonPropertyDescription(value="A UID for an DataSet object  \n(Java name `org.hisp.dhis.dataset.DataSet`)")
    private String dataElement;
    @JsonProperty(value="followup")
    private Boolean followup;
    @JsonProperty(value="orgUnit")
    @JsonPropertyDescription(value="A UID for an OrganisationUnit object  \n(Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)")
    private String orgUnit;
    @JsonProperty(value="period")
    private String period;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();
    private static final long serialVersionUID = -2416244536443105832L;

    public DataValueFollowUpRequest() {
    }

    public DataValueFollowUpRequest(DataValueFollowUpRequest source) {
        this.attribute = source.attribute;
        this.attributeOptionCombo = source.attributeOptionCombo;
        this.categoryOptionCombo = source.categoryOptionCombo;
        this.dataElement = source.dataElement;
        this.followup = source.followup;
        this.orgUnit = source.orgUnit;
        this.period = source.period;
    }

    public DataValueFollowUpRequest(DataValueCategoryDto attribute, String attributeOptionCombo, String categoryOptionCombo, String dataElement, Boolean followup, String orgUnit, String period) {
        this.attribute = attribute;
        this.attributeOptionCombo = attributeOptionCombo;
        this.categoryOptionCombo = categoryOptionCombo;
        this.dataElement = dataElement;
        this.followup = followup;
        this.orgUnit = orgUnit;
        this.period = period;
    }

    @JsonProperty(value="attribute")
    public Optional<DataValueCategoryDto> getAttribute() {
        return Optional.ofNullable(this.attribute);
    }

    @JsonProperty(value="attribute")
    public void setAttribute(DataValueCategoryDto attribute) {
        this.attribute = attribute;
    }

    public DataValueFollowUpRequest withAttribute(DataValueCategoryDto attribute) {
        this.attribute = attribute;
        return this;
    }

    @JsonProperty(value="attributeOptionCombo")
    public Optional<String> getAttributeOptionCombo() {
        return Optional.ofNullable(this.attributeOptionCombo);
    }

    @JsonProperty(value="attributeOptionCombo")
    public void setAttributeOptionCombo(String attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
    }

    public DataValueFollowUpRequest withAttributeOptionCombo(String attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
        return this;
    }

    @JsonProperty(value="categoryOptionCombo")
    public Optional<String> getCategoryOptionCombo() {
        return Optional.ofNullable(this.categoryOptionCombo);
    }

    @JsonProperty(value="categoryOptionCombo")
    public void setCategoryOptionCombo(String categoryOptionCombo) {
        this.categoryOptionCombo = categoryOptionCombo;
    }

    public DataValueFollowUpRequest withCategoryOptionCombo(String categoryOptionCombo) {
        this.categoryOptionCombo = categoryOptionCombo;
        return this;
    }

    @JsonProperty(value="dataElement")
    public Optional<String> getDataElement() {
        return Optional.ofNullable(this.dataElement);
    }

    @JsonProperty(value="dataElement")
    public void setDataElement(String dataElement) {
        this.dataElement = dataElement;
    }

    public DataValueFollowUpRequest withDataElement(String dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    @JsonProperty(value="followup")
    public Optional<Boolean> getFollowup() {
        return Optional.ofNullable(this.followup);
    }

    @JsonProperty(value="followup")
    public void setFollowup(Boolean followup) {
        this.followup = followup;
    }

    public DataValueFollowUpRequest withFollowup(Boolean followup) {
        this.followup = followup;
        return this;
    }

    @JsonProperty(value="orgUnit")
    public Optional<String> getOrgUnit() {
        return Optional.ofNullable(this.orgUnit);
    }

    @JsonProperty(value="orgUnit")
    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    public DataValueFollowUpRequest withOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
        return this;
    }

    @JsonProperty(value="period")
    public Optional<String> getPeriod() {
        return Optional.ofNullable(this.period);
    }

    @JsonProperty(value="period")
    public void setPeriod(String period) {
        this.period = period;
    }

    public DataValueFollowUpRequest withPeriod(String period) {
        this.period = period;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataValueFollowUpRequest withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("attribute".equals(name)) {
            if (!(value instanceof DataValueCategoryDto)) {
                throw new IllegalArgumentException("property \"attribute\" is of type \"org.hisp.dhis.api.model.v40_2_2.DataValueCategoryDto\", but got " + value.getClass().toString());
            }
            this.setAttribute((DataValueCategoryDto)value);
            return true;
        }
        if ("attributeOptionCombo".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"attributeOptionCombo\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setAttributeOptionCombo((String)value);
            return true;
        }
        if ("categoryOptionCombo".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"categoryOptionCombo\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setCategoryOptionCombo((String)value);
            return true;
        }
        if ("dataElement".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"dataElement\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setDataElement((String)value);
            return true;
        }
        if ("followup".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"followup\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setFollowup((Boolean)value);
            return true;
        }
        if ("orgUnit".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"orgUnit\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setOrgUnit((String)value);
            return true;
        }
        if ("period".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"period\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setPeriod((String)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("attribute".equals(name)) {
            return this.getAttribute();
        }
        if ("attributeOptionCombo".equals(name)) {
            return this.getAttributeOptionCombo();
        }
        if ("categoryOptionCombo".equals(name)) {
            return this.getCategoryOptionCombo();
        }
        if ("dataElement".equals(name)) {
            return this.getDataElement();
        }
        if ("followup".equals(name)) {
            return this.getFollowup();
        }
        if ("orgUnit".equals(name)) {
            return this.getOrgUnit();
        }
        if ("period".equals(name)) {
            return this.getPeriod();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public DataValueFollowUpRequest with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataValueFollowUpRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attribute");
        sb.append('=');
        sb.append(this.attribute == null ? "<null>" : this.attribute);
        sb.append(',');
        sb.append("attributeOptionCombo");
        sb.append('=');
        sb.append(this.attributeOptionCombo == null ? "<null>" : this.attributeOptionCombo);
        sb.append(',');
        sb.append("categoryOptionCombo");
        sb.append('=');
        sb.append(this.categoryOptionCombo == null ? "<null>" : this.categoryOptionCombo);
        sb.append(',');
        sb.append("dataElement");
        sb.append('=');
        sb.append(this.dataElement == null ? "<null>" : this.dataElement);
        sb.append(',');
        sb.append("followup");
        sb.append('=');
        sb.append(this.followup == null ? "<null>" : this.followup);
        sb.append(',');
        sb.append("orgUnit");
        sb.append('=');
        sb.append(this.orgUnit == null ? "<null>" : this.orgUnit);
        sb.append(',');
        sb.append("period");
        sb.append('=');
        sb.append(this.period == null ? "<null>" : this.period);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.followup == null ? 0 : this.followup.hashCode());
        result = result * 31 + (this.period == null ? 0 : this.period.hashCode());
        result = result * 31 + (this.attributeOptionCombo == null ? 0 : this.attributeOptionCombo.hashCode());
        result = result * 31 + (this.orgUnit == null ? 0 : this.orgUnit.hashCode());
        result = result * 31 + (this.categoryOptionCombo == null ? 0 : this.categoryOptionCombo.hashCode());
        result = result * 31 + (this.attribute == null ? 0 : this.attribute.hashCode());
        result = result * 31 + (this.dataElement == null ? 0 : this.dataElement.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DataValueFollowUpRequest)) {
            return false;
        }
        DataValueFollowUpRequest rhs = (DataValueFollowUpRequest)other;
        return (this.followup == rhs.followup || this.followup != null && this.followup.equals(rhs.followup)) && (this.period == rhs.period || this.period != null && this.period.equals(rhs.period)) && (this.attributeOptionCombo == rhs.attributeOptionCombo || this.attributeOptionCombo != null && this.attributeOptionCombo.equals(rhs.attributeOptionCombo)) && (this.orgUnit == rhs.orgUnit || this.orgUnit != null && this.orgUnit.equals(rhs.orgUnit)) && (this.categoryOptionCombo == rhs.categoryOptionCombo || this.categoryOptionCombo != null && this.categoryOptionCombo.equals(rhs.categoryOptionCombo)) && (this.attribute == rhs.attribute || this.attribute != null && this.attribute.equals(rhs.attribute)) && (this.dataElement == rhs.dataElement || this.dataElement != null && this.dataElement.equals(rhs.dataElement)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties));
    }
}

