/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_39_1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum CacheStrategy {
    NO_CACHE("NO_CACHE"),
    CACHE_1_MINUTE("CACHE_1_MINUTE"),
    CACHE_5_MINUTES("CACHE_5_MINUTES"),
    CACHE_10_MINUTES("CACHE_10_MINUTES"),
    CACHE_15_MINUTES("CACHE_15_MINUTES"),
    CACHE_30_MINUTES("CACHE_30_MINUTES"),
    CACHE_1_HOUR("CACHE_1_HOUR"),
    CACHE_6_AM_TOMORROW("CACHE_6AM_TOMORROW"),
    CACHE_TWO_WEEKS("CACHE_TWO_WEEKS"),
    RESPECT_SYSTEM_SETTING("RESPECT_SYSTEM_SETTING");

    private final String value;
    private static final Map<String, CacheStrategy> CONSTANTS;

    private CacheStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static CacheStrategy fromValue(String value) {
        CacheStrategy constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, CacheStrategy>();
        for (CacheStrategy c : CacheStrategy.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

