/*
 * Decompiled with CFR 0.152.
 */
package org.hjug.git;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.hjug.git.GitLogReader;
import org.hjug.git.ScmLogInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangePronenessRanker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChangePronenessRanker.class);
    private final TreeMap<Integer, Integer> changeCountsByTimeStamps = new TreeMap();
    private final Map<String, ScmLogInfo> cachedScmLogInfos = new HashMap<String, ScmLogInfo>();

    public ChangePronenessRanker(GitLogReader repositoryLogReader) {
        try {
            log.info("Capturing change count based on commit timestamps");
            this.changeCountsByTimeStamps.putAll(repositoryLogReader.captureChangeCountByCommitTimestamp());
        }
        catch (IOException | GitAPIException e) {
            log.error("Error reading from repository: {}", (Object)e.getMessage());
        }
    }

    public void rankChangeProneness(List<ScmLogInfo> scmLogInfos) {
        for (ScmLogInfo scmLogInfo : scmLogInfos) {
            if (!this.cachedScmLogInfos.containsKey(scmLogInfo.getPath())) {
                int commitsInRepositorySinceCreation = this.changeCountsByTimeStamps.tailMap(scmLogInfo.getEarliestCommit()).values().stream().mapToInt(i -> i).sum();
                scmLogInfo.setChangeProneness((float)scmLogInfo.getCommitCount() / (float)commitsInRepositorySinceCreation);
                this.cachedScmLogInfos.put(scmLogInfo.getPath(), scmLogInfo);
                continue;
            }
            scmLogInfo.setChangeProneness(this.cachedScmLogInfos.get(scmLogInfo.getPath()).getChangeProneness());
        }
        scmLogInfos.sort(Comparator.comparing(ScmLogInfo::getChangeProneness));
        int rank = 0;
        for (ScmLogInfo scmLogInfo : scmLogInfos) {
            scmLogInfo.setChangePronenessRank(++rank);
        }
    }
}

