/*
 * Decompiled with CFR 0.152.
 */
package org.hobsoft.hamcrest.compose;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class ConjunctionMatcher<T>
extends TypeSafeDiagnosingMatcher<T> {
    private static final String SEPARATOR = " and ";
    private final String compositeDescription;
    private final List<Matcher<T>> matchers;

    ConjunctionMatcher(String compositeDescription, Iterable<Matcher<T>> matchers) {
        Objects.requireNonNull(matchers, "matchers");
        this.compositeDescription = compositeDescription;
        this.matchers = Collections.unmodifiableList(ConjunctionMatcher.toList(matchers));
    }

    public ConjunctionMatcher<T> and(Matcher<T> matcher) {
        Objects.requireNonNull(matcher, "matcher");
        return new ConjunctionMatcher<T>(this.compositeDescription, ConjunctionMatcher.concat(this.matchers, matcher));
    }

    public void describeTo(Description description) {
        if (this.matchers.isEmpty()) {
            description.appendText(this.compositeDescription != null ? this.compositeDescription : "anything");
        } else {
            String start = this.compositeDescription != null ? this.compositeDescription + " " : "";
            description.appendList(start, SEPARATOR, "", this.matchers);
        }
    }

    protected boolean matchesSafely(T actual, Description mismatch) {
        boolean matches = true;
        for (Matcher<T> matcher : this.matchers) {
            if (matcher.matches(actual)) continue;
            if (!matches) {
                mismatch.appendText(SEPARATOR);
            }
            matches = false;
            matcher.describeMismatch(actual, mismatch);
        }
        return matches;
    }

    private static <E> List<E> toList(Iterable<E> iterable) {
        ArrayList list = new ArrayList();
        iterable.forEach(list::add);
        return list;
    }

    private static <E> List<E> concat(List<E> list, E element) {
        ArrayList<E> newList = new ArrayList<E>(list);
        newList.add(element);
        return newList;
    }
}

