/*
 * Decompiled with CFR 0.152.
 */
package org.hobsoft.hamcrest.compose;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hobsoft.hamcrest.compose.ConjunctionMatcher;
import org.hobsoft.hamcrest.compose.HasFeatureMatcher;

public final class ComposeMatchers {
    private ComposeMatchers() {
        throw new AssertionError();
    }

    @SafeVarargs
    public static <T> ConjunctionMatcher<T> compose(Matcher<? super T> ... matchers) {
        return ComposeMatchers.compose(null, matchers);
    }

    @SafeVarargs
    public static <T> ConjunctionMatcher<T> compose(String compositeDescription, Matcher<? super T> ... matchers) {
        Objects.requireNonNull(matchers, "matchers");
        return ComposeMatchers.compose(compositeDescription, Arrays.asList(matchers));
    }

    public static <T> ConjunctionMatcher<T> compose(Iterable<Matcher<? super T>> matchers) {
        return ComposeMatchers.compose(null, matchers);
    }

    public static <T> ConjunctionMatcher<T> compose(String compositeDescription, Iterable<Matcher<? super T>> matchers) {
        Objects.requireNonNull(matchers, "matchers");
        return new ConjunctionMatcher<T>(compositeDescription, matchers);
    }

    public static <T, U> Matcher<T> hasFeature(Function<T, U> featureFunction, Matcher<? super U> featureMatcher) {
        return ComposeMatchers.hasFeature(featureFunction.toString(), featureFunction, featureMatcher);
    }

    public static <T, U> Matcher<T> hasFeature(String featureName, Function<T, U> featureFunction, Matcher<? super U> featureMatcher) {
        return ComposeMatchers.hasFeature(featureName, featureName, featureFunction, featureMatcher);
    }

    public static <T, U> Matcher<T> hasFeature(String featureDescription, String featureName, Function<T, U> featureFunction, Matcher<? super U> featureMatcher) {
        return new HasFeatureMatcher<T, U>(featureDescription, featureName, featureFunction, featureMatcher);
    }

    public static <T, U> Matcher<T> hasFeatureValue(Function<T, U> featureFunction, U featureValue) {
        return ComposeMatchers.hasFeature(featureFunction, CoreMatchers.equalTo(featureValue));
    }

    public static <T, U> Matcher<T> hasFeatureValue(String featureName, Function<T, U> featureFunction, U featureValue) {
        return ComposeMatchers.hasFeature(featureName, featureFunction, CoreMatchers.equalTo(featureValue));
    }

    public static <T, U> Matcher<T> hasFeatureValue(String featureDescription, String featureName, Function<T, U> featureFunction, U featureValue) {
        return ComposeMatchers.hasFeature(featureDescription, featureName, featureFunction, CoreMatchers.equalTo(featureValue));
    }
}

