/*
 * Decompiled with CFR 0.152.
 */
package org.hobsoft.spring.resttemplatelogger;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.hobsoft.spring.resttemplatelogger.LogFormatter;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class LoggingInterceptor
implements ClientHttpRequestInterceptor {
    private final Log log;
    private final LogFormatter formatter;

    public LoggingInterceptor(Log log, LogFormatter formatter) {
        this.log = log;
        this.formatter = formatter;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.formatter.formatRequest(request, body));
        }
        ClientHttpResponse response = execution.execute(request, body);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.formatter.formatResponse(response));
        }
        return response;
    }
}

