/*
 * Decompiled with CFR 0.152.
 */
package org.holodeckb2b.commons.security;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.Extension;
import org.holodeckb2b.commons.security.HB2BStyle;
import org.holodeckb2b.commons.util.Utils;

public class CertificateUtils {
    private static final String PEM_START_BOUNDARY = "-----BEGIN CERTIFICATE-----";
    private static final String PEM_END_BOUNDARY = "-----END CERTIFICATE-----";
    private static CertificateFactory certificateFactory;

    public static X509Certificate getCertificate(String b64EncodedCertificate) throws CertificateException {
        if (Utils.isNullOrEmpty(b64EncodedCertificate)) {
            return null;
        }
        int startBIdx = b64EncodedCertificate.indexOf(PEM_START_BOUNDARY);
        int endBIdx = b64EncodedCertificate.indexOf(PEM_END_BOUNDARY);
        String encodedBytes = startBIdx >= 0 ? b64EncodedCertificate.substring(b64EncodedCertificate.indexOf(10, startBIdx), endBIdx > 0 ? endBIdx : b64EncodedCertificate.length()) : b64EncodedCertificate;
        byte[] certBytes = null;
        try {
            certBytes = org.bouncycastle.util.encoders.Base64.decode((String)encodedBytes);
        }
        catch (Exception decodingFailure) {
            throw new CertificateException("String is not a valid base64 encoding", decodingFailure);
        }
        return CertificateUtils.getCertificate(certBytes);
    }

    public static X509Certificate getCertificate(Path certificateFile) throws CertificateException {
        X509Certificate x509Certificate;
        if (certificateFile == null) {
            throw new IllegalArgumentException("A path must be specified");
        }
        FileInputStream fis = new FileInputStream(certificateFile.toFile());
        try {
            x509Certificate = CertificateUtils.getCertificate(fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new CertificateException("Error accessing certificate file");
            }
        }
        fis.close();
        return x509Certificate;
    }

    public static X509Certificate getCertificate(byte[] certBytes) throws CertificateException {
        if (certBytes == null || certBytes.length == 0) {
            return null;
        }
        return CertificateUtils.getCertificate(new ByteArrayInputStream(certBytes));
    }

    public static X509Certificate getCertificate(InputStream is) throws CertificateException {
        if (is == null) {
            throw new IllegalArgumentException("A stream must be specified");
        }
        return (X509Certificate)CertificateUtils.getCertificateFactory().generateCertificate(is);
    }

    public static List<X509Certificate> getCertificates(InputStream is) throws CertificateException {
        if (is == null) {
            throw new IllegalArgumentException("A stream must be specified");
        }
        try {
            return CertificateUtils.getCertificateFactory().generateCertificates(is).stream().map(c -> (X509Certificate)c).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new CertificateException("Invalid certificate chain");
        }
    }

    public static String getPEMEncoded(X509Certificate cert) throws CertificateException {
        if (cert == null) {
            return null;
        }
        StringBuilder pemEncoded = new StringBuilder(PEM_START_BOUNDARY).append('\n');
        pemEncoded.append(Base64.getMimeEncoder(64, "\n".getBytes()).encodeToString(cert.getEncoded()));
        pemEncoded.append('\n').append(PEM_END_BOUNDARY);
        return pemEncoded.toString();
    }

    public static String getSubjectCN(X509Certificate cert) {
        return CertificateUtils.getSubjectDNField(cert, BCStyle.CN);
    }

    public static String getSubjectName(X509Certificate cert) {
        return X500Name.getInstance((X500NameStyle)HB2BStyle.INSTANCE, (Object)cert.getSubjectX500Principal().getEncoded()).toString();
    }

    public static String getIssuerCN(X509Certificate cert) {
        try {
            X500Name x500name = X500Name.getInstance((Object)cert.getIssuerX500Principal().getEncoded());
            RDN cn = x500name.getRDNs(BCStyle.CN)[0];
            return IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
        }
        catch (Exception invalidCert) {
            return null;
        }
    }

    public static String getIssuerName(X509Certificate cert) {
        return X500Name.getInstance((X500NameStyle)HB2BStyle.INSTANCE, (Object)cert.getIssuerX500Principal().getEncoded()).toString();
    }

    public static String getSubjectSN(X509Certificate cert) {
        return CertificateUtils.getSubjectDNField(cert, BCStyle.SERIALNUMBER);
    }

    public static String getSubjectDNField(X509Certificate cert, ASN1ObjectIdentifier field) {
        try {
            X500Name x500name = X500Name.getInstance((Object)cert.getSubjectX500Principal().getEncoded());
            RDN cn = x500name.getRDNs(field)[0];
            return IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
        }
        catch (Exception invalidCert) {
            return null;
        }
    }

    public static byte[] getSKI(X509Certificate cert) {
        byte[] skiExtValue = cert.getExtensionValue(Extension.subjectKeyIdentifier.getId());
        return skiExtValue != null ? Arrays.copyOfRange(skiExtValue, 4, skiExtValue.length) : null;
    }

    public static boolean hasSKI(X509Certificate cert, byte[] skiBytes) {
        byte[] certSKI = CertificateUtils.getSKI(cert);
        return certSKI != null && Arrays.equals(certSKI, skiBytes);
    }

    public static boolean hasIssuerSerial(X509Certificate cert, X500Principal issuer, BigInteger serial) {
        return new X500Name(cert.getIssuerX500Principal().getName()).equals((Object)new X500Name(issuer.getName())) && cert.getSerialNumber().equals(serial);
    }

    public static boolean hasThumbprint(X509Certificate cert, byte[] hash, MessageDigest digester) {
        try {
            digester.reset();
            return Arrays.equals(digester.digest(cert.getEncoded()), hash);
        }
        catch (CertificateEncodingException ex) {
            return false;
        }
    }

    private static CertificateFactory getCertificateFactory() throws CertificateException {
        if (certificateFactory == null) {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        return certificateFactory;
    }
}

