/*
 * Decompiled with CFR 0.152.
 */
package org.holodeckb2b.commons.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.tika.Tika;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.holodeckb2b.commons.util.Utils;

public final class FileUtils {
    public static String detectMimeType(String f) throws IOException {
        return FileUtils.detectMimeType(new File(f));
    }

    public static String detectMimeType(Path f) throws IOException {
        return FileUtils.detectMimeType(f.toFile());
    }

    public static String detectMimeType(File f) throws IOException {
        return SingletonHolder.mimeTypeDetector.detect(f).toString();
    }

    public static String detectMimeType(InputStream is) throws IOException {
        return SingletonHolder.mimeTypeDetector.detect(is).toString();
    }

    public static String getExtension(String mimeType) {
        if (Utils.isNullOrEmpty(mimeType)) {
            return null;
        }
        MimeTypes allTypes = MimeTypes.getDefaultMimeTypes();
        MimeType tikaMimeType = null;
        try {
            tikaMimeType = allTypes.forName(mimeType);
        }
        catch (MimeTypeException ex) {
            return null;
        }
        return tikaMimeType.getExtension();
    }

    public static Path createFileWithUniqueName(String baseName) throws IOException {
        return Utils.isNullOrEmpty(baseName) ? null : FileUtils.createFileWithUniqueName(Paths.get(baseName, new String[0]));
    }

    public static Path createFileWithUniqueName(Path basePath) throws IOException {
        if (basePath == null) {
            return null;
        }
        String nameOnly = basePath.getFileName().toString();
        String ext = "";
        int startExt = nameOnly.lastIndexOf(".");
        if (startExt > 0) {
            ext = nameOnly.substring(startExt);
            nameOnly = nameOnly.substring(0, startExt);
        }
        Path targetPath = basePath.getParent().resolve(nameOnly + ext);
        File f = null;
        int i = 1;
        while (f == null) {
            try {
                f = Files.createFile(targetPath, new FileAttribute[0]).toFile();
            }
            catch (FileAlreadyExistsException faee) {
                targetPath = basePath.getParent().resolve(nameOnly + "-" + i++ + ext);
            }
        }
        return targetPath;
    }

    public static boolean isWriteableDirectory(String path) {
        try {
            return FileUtils.isWriteableDirectory(Paths.get(path, new String[0]));
        }
        catch (InvalidPathException e) {
            return false;
        }
    }

    public static boolean isWriteableDirectory(Path p) {
        return p != null && Files.isDirectory(p, new LinkOption[0]) && Files.isWritable(p);
    }

    public static void removeDirectory(Path dir) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException("Path to directory not specified");
        }
        if (!Files.exists(dir, new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) {
            return;
        }
        FileUtils.cleanDirectory(dir);
        if (!Files.deleteIfExists(dir)) {
            throw new IOException("Could not remove directory " + dir.toString());
        }
    }

    public static void cleanDirectory(Path dir) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException("Path to directory not specified");
        }
        if (!Files.exists(dir, new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) {
            throw new FileNotFoundException(dir.toString());
        }
        for (File f : dir.toFile().listFiles()) {
            if (f.isDirectory()) {
                FileUtils.removeDirectory(f.toPath());
                continue;
            }
            if (f.delete()) continue;
            throw new IOException("Could not remove file " + f.toString());
        }
    }

    public static void sortFiles(File[] array) {
        if (array != null && array.length > 1) {
            Arrays.sort(array, (aO1, aO2) -> aO1.getName().compareTo(aO2.getName()));
        }
    }

    public static String sanitizeFileName(String name) {
        return name.replaceAll("[^a-zA-Z0-9.\\-_]", "_").toLowerCase();
    }

    private FileUtils() {
    }

    private static final class SingletonHolder {
        static final Tika mimeTypeDetector = new Tika();

        private SingletonHolder() {
        }
    }
}

