/*
 * Decompiled with CFR 0.152.
 */
package org.holodeckb2b.commons.util;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.holodeckb2b.commons.util.Utils;

public class MessageIdUtils {
    private static final String RIGHT_PART;
    private static final String RFC2822_MESSAGE_ID;
    private static final String VALID_CHARS;

    public static String createMessageId() {
        return UUID.randomUUID().toString() + '@' + RIGHT_PART;
    }

    public static String createMessageId(String rightPart) {
        return UUID.randomUUID().toString() + '@' + rightPart.replaceAll("[^" + VALID_CHARS + "]", "_");
    }

    public static String createContentId(String msgId) {
        String rightPart;
        String leftPart;
        if (Utils.isNullOrEmpty(msgId)) {
            return MessageIdUtils.createMessageId();
        }
        int i = msgId.indexOf("@");
        if (i > 0) {
            leftPart = msgId.substring(0, i);
            rightPart = msgId.substring(i);
        } else {
            leftPart = msgId;
            rightPart = "";
        }
        leftPart = leftPart + "-" + String.valueOf(ThreadLocalRandom.current().nextInt(0, Integer.MAX_VALUE));
        return (leftPart + rightPart).replaceAll("[^" + VALID_CHARS + "]", "_");
    }

    public static String sanitizeId(String msgId) {
        return msgId == null ? null : msgId.replaceAll("[^" + VALID_CHARS + "]", "_");
    }

    public static boolean isAllowed(String messageId) {
        if (Utils.isNullOrEmpty(messageId)) {
            return false;
        }
        return messageId.matches("[" + VALID_CHARS + "]*");
    }

    public static boolean isCorrectFormat(String messageId) {
        if (Utils.isNullOrEmpty(messageId)) {
            return false;
        }
        return messageId.matches(RFC2822_MESSAGE_ID);
    }

    public static String stripBrackets(String messageId) {
        if (messageId == null) {
            return null;
        }
        String msgIdOnly = messageId;
        if (msgIdOnly.startsWith("<")) {
            msgIdOnly = msgIdOnly.substring(1);
        }
        if (msgIdOnly.endsWith(">")) {
            msgIdOnly = msgIdOnly.substring(0, msgIdOnly.length() - 1);
        }
        return msgIdOnly;
    }

    static {
        String dot_atom_text;
        RIGHT_PART = "h-" + Long.toHexString(Double.doubleToLongBits(Math.random())) + "." + Long.toHexString(Double.doubleToLongBits(Math.random()));
        String ALPHA = "\\p{Alpha}";
        String DIGIT = "\\d";
        String achars = ALPHA + DIGIT + "\\Q!#$%&'*+-/=?^_`{|}~\\E";
        String atext = "[" + achars + "]";
        String id_left = dot_atom_text = atext + "+(\\." + atext + "+)*";
        String id_right = dot_atom_text;
        RFC2822_MESSAGE_ID = id_left + "@" + id_right;
        VALID_CHARS = achars + "\\.@";
    }
}

