/*
 * Decompiled with CFR 0.152.
 */
package org.holodeckb2b.commons.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.holodeckb2b.commons.util.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLElementFinder
extends DefaultHandler {
    private final Document document;
    private Node currentNode;
    private QName elementToRead;
    private boolean parsingActive;
    private int maxElements;
    int elementsSeen = 0;

    public static Element parse(InputStream is, QName element) {
        return XMLElementFinder.parse(is, element, -1);
    }

    public static Element parse(InputStream is, QName element, int searchLimit) {
        XMLElementFinder processor = new XMLElementFinder(element, searchLimit);
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            XMLReader xmlReader = saxParserFactory.newSAXParser().getXMLReader();
            xmlReader.setContentHandler(processor);
            xmlReader.parse(new InputSource(is));
            return processor.document.getDocumentElement();
        }
        catch (StopSaxParserException e) {
            return processor.document != null ? processor.document.getDocumentElement() : null;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    private XMLElementFinder(QName element, int searchLimit) {
        this.elementToRead = element;
        this.maxElements = searchLimit;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.document = documentBuilder.newDocument();
            this.currentNode = this.document;
            this.parsingActive = false;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attrs) throws StopSaxParserException {
        ++this.elementsSeen;
        this.parsingActive |= Utils.isNullOrEmpty(this.elementToRead.getNamespaceURI()) ? this.elementToRead.getLocalPart().equals(name) : this.elementToRead.equals(new QName(uri, name));
        if (!this.parsingActive && this.maxElements > 0 && this.elementsSeen >= this.maxElements) {
            throw new StopSaxParserException();
        }
        if (!this.parsingActive) {
            return;
        }
        Element elem = this.document.createElementNS(uri, qName);
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = this.document.createAttributeNS(attrs.getURI(i), attrs.getQName(i));
            attr.setValue(attrs.getValue(i));
            elem.setAttributeNodeNS(attr);
        }
        this.currentNode.appendChild(elem);
        this.currentNode = elem;
    }

    @Override
    public void endElement(String uri, String name, String qName) throws StopSaxParserException {
        if (!this.parsingActive) {
            return;
        }
        this.currentNode = this.currentNode.getParentNode();
        if (Utils.isNullOrEmpty(this.elementToRead.getNamespaceURI()) && this.elementToRead.getLocalPart().equals(name) || this.elementToRead.equals(new QName(uri, name))) {
            throw new StopSaxParserException();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (!this.parsingActive) {
            return;
        }
        this.currentNode.appendChild(this.document.createTextNode(new String(ch, start, length)));
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        if (!this.parsingActive) {
            return;
        }
        this.currentNode.appendChild(this.document.createTextNode(new String(ch, start, length)));
    }

    @Override
    public void processingInstruction(String target, String data) {
        if (!this.parsingActive) {
            return;
        }
        this.currentNode.appendChild(this.document.createProcessingInstruction(target, data));
    }

    @Override
    public void error(SAXParseException e) {
        throw new IllegalStateException("Error at line " + e.getLineNumber() + ", column " + e.getColumnNumber() + " : " + e.getMessage(), e);
    }

    @Override
    public void fatalError(SAXParseException e) {
        throw new IllegalStateException("Fatal error at line " + e.getLineNumber() + ", column " + e.getColumnNumber() + " : " + e.getMessage(), e);
    }

    @Override
    public void warning(SAXParseException e) {
    }

    private class StopSaxParserException
    extends SAXException {
        private StopSaxParserException() {
        }
    }
}

