/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.dogstatd.model;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolFamily;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.UnsupportedAddressTypeException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.honton.chas.dogstatd.model.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sender {
    private static final Logger log = LoggerFactory.getLogger(Sender.class);
    private static final int MTU = 1440;
    private static final long ONE_MINUTE = TimeUnit.MINUTES.toMillis(1L);
    private final DatagramChannel clientChannel;
    private volatile long throttleEnd;
    private long throttleInterval;

    public Sender() {
        this(InetAddress.getLoopbackAddress());
    }

    public Sender(String address) {
        this(Sender.getAddress(address));
    }

    private static InetAddress getAddress(String address) {
        return InetAddress.getByName(address);
    }

    public Sender(InetAddress address) {
        this(new InetSocketAddress(address, 8125));
    }

    public Sender(InetSocketAddress socket) {
        this(socket, ONE_MINUTE);
    }

    public Sender(InetSocketAddress socket, long throttleInterval) {
        this.clientChannel = DatagramChannel.open(this.getProtocol(socket.getAddress()));
        this.clientChannel.configureBlocking(false);
        this.clientChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)1440);
        this.clientChannel.connect(socket);
        this.throttleInterval = throttleInterval;
    }

    private ProtocolFamily getProtocol(InetAddress host) {
        if (host instanceof Inet4Address) {
            return StandardProtocolFamily.INET;
        }
        if (host instanceof Inet6Address) {
            return StandardProtocolFamily.INET6;
        }
        throw new UnsupportedAddressTypeException();
    }

    public boolean send(Message message) {
        if (this.throttleEnd != 0L) {
            if (System.currentTimeMillis() < this.throttleEnd) {
                return false;
            }
            this.throttleEnd = 0L;
        }
        if (!message.validate()) {
            return false;
        }
        CharBuffer chars = CharBuffer.allocate(1400);
        chars.clear();
        try {
            message.format(chars);
        }
        catch (BufferOverflowException boe) {
            log.info("too large of message {}", (Object)message);
            return false;
        }
        chars.flip();
        ByteBuffer bytes = StandardCharsets.UTF_8.encode(chars);
        try {
            this.clientChannel.write(bytes);
            return true;
        }
        catch (IOException pue) {
            this.throttleEnd = System.currentTimeMillis() + this.throttleInterval;
            log.warn("failed to send message {}", (Object)message);
            return false;
        }
    }

    void shutdown() throws IOException {
        this.clientChannel.close();
    }

    boolean isThrottled() {
        return this.throttleEnd != 0L;
    }
}

