/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.process.exec.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.logging.Log;
import org.honton.chas.process.exec.maven.plugin.AbstractProcessMojo;
import org.honton.chas.process.exec.maven.plugin.StdoutRedirector;

public class ExecProcess {
    private Process process;
    private File processLogFile;
    private final String name;
    private final Log log;

    public ExecProcess(String name, Log log) {
        this.name = name;
        this.log = log;
    }

    public void setProcessLogFile(File emoLogFile) {
        this.processLogFile = emoLogFile;
    }

    public String getName() {
        return this.name;
    }

    public void execute(File workingDirectory, Map<String, String> environment, List<String> args) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        this.log.debug((CharSequence)("Using working directory for this process: " + workingDirectory));
        pb.directory(workingDirectory);
        if (environment != null) {
            pb.environment().putAll(environment);
        }
        ExecProcess.removeNullElements(args);
        pb.command(args);
        if (this.processLogFile != null) {
            this.redirectToLogFile(pb);
        }
        this.process = pb.start();
        if (this.processLogFile == null) {
            this.redirectStream();
        }
    }

    private static void removeNullElements(List<String> args) {
        ListIterator<String> it = args.listIterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
    }

    private void redirectToLogFile(ProcessBuilder pb) throws IOException {
        AbstractProcessMojo.ensureDirectory(this.processLogFile.getParentFile());
        this.log.debug((CharSequence)("redirecting out/err to " + this.processLogFile));
        pb.redirectErrorStream(true).redirectOutput(this.processLogFile);
    }

    private void redirectStream() throws IOException {
        new StdoutRedirector(this.name, this.process.getInputStream(), new StdoutRedirector.LineWriter(){

            @Override
            public void writeLine(String line) {
                ExecProcess.this.log.info((CharSequence)line);
            }
        });
        new StdoutRedirector(this.name, this.process.getErrorStream(), new StdoutRedirector.LineWriter(){

            @Override
            public void writeLine(String line) {
                ExecProcess.this.log.error((CharSequence)line);
            }
        });
    }

    public void destroy() {
        this.log.info((CharSequence)("Stopping process: " + this.name));
        this.process.destroy();
        this.waitForExit();
    }

    private int waitForExit() {
        for (int t = 0; t < 30; ++t) {
            try {
                int rc = this.process.exitValue();
                this.log.info((CharSequence)("Stopped process: " + this.name + " exit code " + rc));
                return rc;
            }
            catch (IllegalThreadStateException e) {
                this.log.debug((CharSequence)("process " + this.name + " not exited after " + t + " seconds"));
                ExecProcess.waitSeconds(1);
                continue;
            }
        }
        this.log.error((CharSequence)("Process " + this.name + " not stopped after 30 seconds"));
        return -1;
    }

    private static void waitSeconds(int x) {
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(x));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

