/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.maven.readfiles;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="readfiles", defaultPhase=LifecyclePhase.INITIALIZE)
public class ReadFilesMojo
extends AbstractMojo {
    @Parameter(defaultValue="")
    private String prefix;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(defaultValue="false", property="readfiles.skip")
    private boolean skip;
    @Parameter(defaultValue="${project.properties}", readonly=true, required=true)
    private Properties projectProperties;
    private Charset charset;
    @Parameter
    private File[] files;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping");
            return;
        }
        this.charset = this.createCharset();
        try {
            for (File file : this.files) {
                String propertyName = this.createPropertyName(file);
                String propertyValue = this.readFileFully(file);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)(propertyName + " = " + propertyValue));
                } else {
                    this.getLog().info((CharSequence)("setting " + propertyName));
                }
                this.projectProperties.setProperty(propertyName, propertyValue);
            }
        }
        catch (IOException io) {
            throw new MojoExecutionException(io.getMessage(), (Exception)io);
        }
    }

    private String createPropertyName(File file) {
        return this.prefix != null ? this.prefix + file.getName() : file.getName();
    }

    private Charset createCharset() {
        return this.encoding != null ? Charset.forName(this.encoding) : StandardCharsets.UTF_8;
    }

    private String readFileFully(File file) throws IOException {
        byte[] encoded = Files.readAllBytes(file.toPath());
        return new String(encoded, this.charset);
    }
}

