/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.integration.aerogear;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.filter.impl.FilterImpl;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.server.ConnectorService;
import org.hornetq.core.server.Consumer;
import org.hornetq.core.server.HandleStatus;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.integration.aerogear.AeroGearConstants;
import org.hornetq.integration.aerogear.HornetQAeroGearBundle;
import org.hornetq.integration.aerogear.HornetQAeroGearLogger;
import org.hornetq.utils.ConfigurationHelper;
import org.jboss.aerogear.unifiedpush.SenderClient;
import org.jboss.aerogear.unifiedpush.message.MessageResponseCallback;
import org.jboss.aerogear.unifiedpush.message.UnifiedMessage;

public class AeroGearConnectorService
implements ConnectorService,
Consumer,
MessageResponseCallback {
    private final String connectorName;
    private final PostOffice postOffice;
    private final ScheduledExecutorService scheduledThreadPool;
    private final String queueName;
    private final String endpoint;
    private final String applicationId;
    private final String applicationMasterSecret;
    private final int ttl;
    private final String badge;
    private final String sound;
    private final boolean contentAvailable;
    private final String actionCategory;
    private String[] variants;
    private String[] aliases;
    private String[] deviceTypes;
    private final String filterString;
    private final int retryInterval;
    private final int retryAttempts;
    private Queue queue;
    private Filter filter;
    private volatile boolean handled = false;
    private boolean started = false;
    private boolean reconnecting = false;

    public AeroGearConnectorService(String connectorName, Map<String, Object> configuration, PostOffice postOffice, ScheduledExecutorService scheduledThreadPool) {
        String deviceTypeString;
        String aliasesString;
        this.connectorName = connectorName;
        this.postOffice = postOffice;
        this.scheduledThreadPool = scheduledThreadPool;
        this.queueName = ConfigurationHelper.getStringProperty((String)"queue", null, configuration);
        this.endpoint = ConfigurationHelper.getStringProperty((String)"endpoint", null, configuration);
        this.applicationId = ConfigurationHelper.getStringProperty((String)"application-id", null, configuration);
        this.applicationMasterSecret = ConfigurationHelper.getStringProperty((String)"master-secret", null, configuration);
        this.ttl = ConfigurationHelper.getIntProperty((String)"ttl", (int)AeroGearConstants.DEFAULT_TTL, configuration);
        this.badge = ConfigurationHelper.getStringProperty((String)"badge", null, configuration);
        this.sound = ConfigurationHelper.getStringProperty((String)"sound", (String)"default", configuration);
        this.contentAvailable = ConfigurationHelper.getBooleanProperty((String)"content-available", (boolean)false, configuration);
        this.actionCategory = ConfigurationHelper.getStringProperty((String)"action-category", null, configuration);
        this.filterString = ConfigurationHelper.getStringProperty((String)"filter", null, configuration);
        this.retryInterval = ConfigurationHelper.getIntProperty((String)"retry-interval", (int)5, configuration);
        this.retryAttempts = ConfigurationHelper.getIntProperty((String)"retry-attempts", (int)5, configuration);
        String variantsString = ConfigurationHelper.getStringProperty((String)"variants", null, configuration);
        if (variantsString != null) {
            this.variants = variantsString.split(",");
        }
        if ((aliasesString = ConfigurationHelper.getStringProperty((String)"aliases", null, configuration)) != null) {
            this.aliases = aliasesString.split(",");
        }
        if ((deviceTypeString = ConfigurationHelper.getStringProperty((String)"device-types", null, configuration)) != null) {
            this.deviceTypes = deviceTypeString.split(",");
        }
    }

    public String getName() {
        return this.connectorName;
    }

    public void start() throws Exception {
        if (this.started) {
            return;
        }
        if (this.filterString != null) {
            this.filter = FilterImpl.createFilter((String)this.filterString);
        }
        if (this.endpoint == null || this.endpoint.isEmpty()) {
            throw HornetQAeroGearBundle.BUNDLE.endpointNull();
        }
        if (this.applicationId == null || this.applicationId.isEmpty()) {
            throw HornetQAeroGearBundle.BUNDLE.applicationIdNull();
        }
        if (this.applicationMasterSecret == null || this.applicationMasterSecret.isEmpty()) {
            throw HornetQAeroGearBundle.BUNDLE.masterSecretNull();
        }
        Binding b = this.postOffice.getBinding(new SimpleString(this.queueName));
        if (b == null) {
            throw HornetQAeroGearBundle.BUNDLE.noQueue(this.connectorName, this.queueName);
        }
        this.queue = (Queue)b.getBindable();
        this.queue.addConsumer((Consumer)this);
        this.started = true;
    }

    public void stop() throws Exception {
        if (!this.started) {
            return;
        }
        this.queue.removeConsumer((Consumer)this);
    }

    public boolean isStarted() {
        return this.started;
    }

    public HandleStatus handle(MessageReference reference) throws Exception {
        String[] deviceTypes;
        String[] aliases;
        String[] variants;
        Integer ttl;
        String actionCategory;
        boolean contentAvailable;
        String badge;
        String sound;
        if (this.reconnecting) {
            return HandleStatus.BUSY;
        }
        ServerMessage message = reference.getMessage();
        if (this.filter != null && !this.filter.match(message)) {
            if (HornetQServerLogger.LOGGER.isTraceEnabled()) {
                HornetQServerLogger.LOGGER.trace((Object)("Reference " + reference + " is a noMatch on consumer " + this));
            }
            return HandleStatus.NO_MATCH;
        }
        if (!message.containsProperty(AeroGearConstants.AEROGEAR_ALERT)) {
            return HandleStatus.NO_MATCH;
        }
        String alert = message.getTypedProperties().getProperty(AeroGearConstants.AEROGEAR_ALERT).toString();
        SenderClient sender = new SenderClient.Builder(this.endpoint).build();
        UnifiedMessage.Builder builder = new UnifiedMessage.Builder();
        builder.pushApplicationId(this.applicationId).masterSecret(this.applicationMasterSecret).alert(alert);
        String string = sound = message.containsProperty(AeroGearConstants.AEROGEAR_SOUND) ? message.getStringProperty(AeroGearConstants.AEROGEAR_SOUND) : this.sound;
        if (sound != null) {
            builder.sound(sound);
        }
        String string2 = badge = message.containsProperty(AeroGearConstants.AEROGEAR_BADGE) ? message.getStringProperty(AeroGearConstants.AEROGEAR_BADGE) : this.badge;
        if (badge != null) {
            builder.badge(badge);
        }
        boolean bl = contentAvailable = message.containsProperty(AeroGearConstants.AEROGEAR_CONTENT_AVAILABLE) ? message.getBooleanProperty(AeroGearConstants.AEROGEAR_CONTENT_AVAILABLE) : this.contentAvailable;
        if (contentAvailable) {
            builder.contentAvailable();
        }
        String string3 = actionCategory = message.containsProperty(AeroGearConstants.AEROGEAR_ACTION_CATEGORY) ? message.getStringProperty(AeroGearConstants.AEROGEAR_ACTION_CATEGORY) : this.actionCategory;
        if (actionCategory != null) {
            builder.actionCategory(actionCategory);
        }
        if ((ttl = Integer.valueOf(message.containsProperty(AeroGearConstants.AEROGEAR_TTL) ? message.getIntProperty(AeroGearConstants.AEROGEAR_TTL) : this.ttl)) != null) {
            builder.timeToLive(ttl.intValue());
        }
        String variantsString = message.containsProperty(AeroGearConstants.AEROGEAR_VARIANTS) ? message.getStringProperty(AeroGearConstants.AEROGEAR_VARIANTS) : null;
        String[] stringArray = variants = variantsString != null ? variantsString.split(",") : this.variants;
        if (variants != null) {
            builder.variants(Arrays.asList(variants));
        }
        String aliasesString = message.containsProperty(AeroGearConstants.AEROGEAR_ALIASES) ? message.getStringProperty(AeroGearConstants.AEROGEAR_ALIASES) : null;
        String[] stringArray2 = aliases = aliasesString != null ? aliasesString.split(",") : this.aliases;
        if (aliases != null) {
            builder.aliases(Arrays.asList(aliases));
        }
        String deviceTypesString = message.containsProperty(AeroGearConstants.AEROGEAR_DEVICE_TYPES) ? message.getStringProperty(AeroGearConstants.AEROGEAR_DEVICE_TYPES) : null;
        String[] stringArray3 = deviceTypes = deviceTypesString != null ? deviceTypesString.split(",") : this.deviceTypes;
        if (deviceTypes != null) {
            builder.deviceType(Arrays.asList(deviceTypes));
        }
        Set propertyNames = message.getPropertyNames();
        for (SimpleString propertyName : propertyNames) {
            if (!propertyName.toString().startsWith("AEROGEAR_") || AeroGearConstants.ALLOWABLE_PROPERTIES.contains(propertyName)) continue;
            Object property = message.getTypedProperties().getProperty(propertyName);
            builder.attribute(propertyName.toString(), property.toString());
        }
        UnifiedMessage unifiedMessage = builder.build();
        sender.send(unifiedMessage, (MessageResponseCallback)this);
        if (this.handled) {
            reference.acknowledge();
            return HandleStatus.HANDLED;
        }
        if (!this.started) {
            return HandleStatus.NO_MATCH;
        }
        return HandleStatus.BUSY;
    }

    public void onComplete(int statusCode) {
        if (statusCode != 200) {
            this.handled = false;
            if (statusCode == 401) {
                HornetQAeroGearLogger.LOGGER.reply401();
            } else if (statusCode == 404) {
                HornetQAeroGearLogger.LOGGER.reply404();
            } else {
                HornetQAeroGearLogger.LOGGER.replyUnknown(statusCode);
            }
            this.queue.removeConsumer((Consumer)this);
            this.started = false;
        } else {
            this.handled = true;
        }
    }

    public void onError(Throwable throwable) {
        HornetQAeroGearLogger.LOGGER.sendFailed(this.retryInterval);
        this.handled = false;
        this.reconnecting = true;
        this.scheduledThreadPool.schedule(new ReconnectRunnable(0), (long)this.retryInterval, TimeUnit.SECONDS);
    }

    public List<MessageReference> getDeliveringMessages() {
        return Collections.emptyList();
    }

    public void proceedDeliver(MessageReference reference) throws Exception {
    }

    public Filter getFilter() {
        return this.filter;
    }

    public String debug() {
        return "aerogear connected to " + this.endpoint;
    }

    public String toManagementString() {
        return "aerogear connected to " + this.endpoint;
    }

    public void disconnect() {
    }

    private class ReconnectRunnable
    implements Runnable {
        private int retryAttempt;

        public ReconnectRunnable(int retryAttempt) {
            this.retryAttempt = retryAttempt;
        }

        @Override
        public void run() {
            try {
                HttpURLConnection conn = (HttpURLConnection)new URL(AeroGearConnectorService.this.endpoint).openConnection();
                conn.connect();
                AeroGearConnectorService.this.reconnecting = false;
                HornetQAeroGearLogger.LOGGER.connected(AeroGearConnectorService.this.endpoint);
                AeroGearConnectorService.this.queue.deliverAsync();
            }
            catch (Exception e) {
                ++this.retryAttempt;
                if (AeroGearConnectorService.this.retryAttempts == -1 || this.retryAttempt < AeroGearConnectorService.this.retryAttempts) {
                    AeroGearConnectorService.this.scheduledThreadPool.schedule(this, (long)AeroGearConnectorService.this.retryInterval, TimeUnit.SECONDS);
                }
                HornetQAeroGearLogger.LOGGER.unableToReconnect(this.retryAttempt);
                AeroGearConnectorService.this.started = false;
            }
        }
    }
}

