/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.cli;

import io.airlift.command.Cli;
import io.airlift.command.ParseArgumentsUnexpectedException;
import java.io.InputStream;
import java.io.OutputStream;
import org.hornetq.cli.ConfigurationException;
import org.hornetq.cli.commands.Action;
import org.hornetq.cli.commands.ActionContext;
import org.hornetq.cli.commands.HelpAction;
import org.hornetq.cli.commands.Run;
import org.hornetq.cli.commands.Stop;

public class HornetQ {
    public static void main(String[] args) throws Exception {
        Cli.CliBuilder builder = Cli.builder((String)"hornetq").withDefaultCommand(HelpAction.class).withCommand(Run.class).withCommand(Stop.class).withCommand(HelpAction.class).withDescription("HornetQ Command Line");
        Cli parser = builder.build();
        try {
            ((Action)parser.parse(args)).execute(ActionContext.system());
        }
        catch (ParseArgumentsUnexpectedException e) {
            System.err.println(e.getMessage());
            System.out.println();
            ((Action)parser.parse(new String[]{"help"})).execute(ActionContext.system());
        }
        catch (ConfigurationException configException) {
            System.err.println(configException.getMessage());
            System.out.println();
            System.out.println("Configuration should be specified as 'scheme:location'. Default configuration is 'xml:${HORNETQ_HOME}/config/non-clustered/bootstrap.xml'");
        }
    }

    public static void printBanner() throws Exception {
        HornetQ.copy(HornetQ.class.getResourceAsStream("banner.txt"), System.out);
    }

    private static long copy(InputStream in, OutputStream out) throws Exception {
        byte[] buffer = new byte[1024];
        int len = in.read(buffer);
        while (len != -1) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        return len;
    }
}

