/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.cli.commands;

import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanServer;
import org.hornetq.cli.HornetQ;
import org.hornetq.cli.commands.Action;
import org.hornetq.cli.commands.ActionContext;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.dto.BrokerDTO;
import org.hornetq.factory.BrokerFactory;
import org.hornetq.factory.CoreFactory;
import org.hornetq.factory.JmsFactory;
import org.hornetq.factory.SecurityManagerFactory;
import org.hornetq.integration.bootstrap.HornetQBootstrapLogger;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.config.JMSConfiguration;
import org.hornetq.jms.server.impl.JMSServerManagerImpl;
import org.hornetq.jms.server.impl.StandaloneNamingServer;
import org.hornetq.spi.core.security.HornetQSecurityManager;

@Command(name="run", description="runs the broker instance")
public class Run
implements Action {
    @Arguments(description="Broker Configuration URI, default 'xml:${HORNETQ_HOME}/config/non-clustered/bootstrap.xml'")
    String configuration;
    private StandaloneNamingServer namingServer;
    private JMSServerManager jmsServerManager;

    @Override
    public Object execute(ActionContext context) throws Exception {
        HornetQ.printBanner();
        if (this.configuration == null) {
            this.configuration = "xml:" + System.getProperty("hornetq.home").replace("\\", "/") + "/config/non-clustered/bootstrap.xml";
        }
        System.out.println("Loading configuration file: " + this.configuration);
        BrokerDTO broker = BrokerFactory.createBroker(this.configuration);
        this.addShutdownHook(new File(broker.core.configuration).getParentFile());
        Configuration core = CoreFactory.create(broker.core);
        JMSConfiguration jms = JmsFactory.create(broker.jms);
        HornetQSecurityManager security = SecurityManagerFactory.create(broker.security);
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        HornetQServerImpl server = new HornetQServerImpl(core, mBeanServer, security);
        this.namingServer = new StandaloneNamingServer((HornetQServer)server);
        this.namingServer.setBindAddress(broker.naming.bindAddress);
        this.namingServer.setPort(broker.naming.port);
        this.namingServer.setRmiBindAddress(broker.naming.rmiBindAddress);
        this.namingServer.setRmiPort(broker.naming.rmiPort);
        this.namingServer.start();
        HornetQBootstrapLogger.LOGGER.startedNamingService(broker.naming.bindAddress, broker.naming.port, broker.naming.rmiBindAddress, broker.naming.rmiPort);
        this.jmsServerManager = jms != null ? new JMSServerManagerImpl((HornetQServer)server, jms) : new JMSServerManagerImpl((HornetQServer)server);
        HornetQBootstrapLogger.LOGGER.serverStarting();
        this.jmsServerManager.start();
        return null;
    }

    private void addShutdownHook(File configurationDir) {
        final File file = new File(configurationDir, "STOP_ME");
        if (file.exists() && !file.delete()) {
            HornetQBootstrapLogger.LOGGER.errorDeletingFile(file.getAbsolutePath());
        }
        final Timer timer = new Timer("HornetQ Server Shutdown Timer", true);
        timer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (file.exists()) {
                    try {
                        try {
                            Run.this.jmsServerManager.stop();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        timer.cancel();
                    }
                    finally {
                        Runtime.getRuntime().exit(0);
                    }
                }
            }
        }, 500L, 500L);
    }
}

