/*
 * Copyright 2009 Red Hat, Inc.
 * Red Hat licenses this file to you under the Apache License, version
 * 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *    http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.  See the License for the specific language governing
 * permissions and limitations under the License.
 */

package org.hornetq.api.core;

/**
 * A PropertyConversionException is thrown by {@link org.hornetq.api.core.Message} methods when a
 * property can not be converted to the expected type.
 * @author <a href="mailto:jmesnil@redhat.com">Jeff Mesnil</a>
 * @see org.hornetq.api.core.Message
 */
public final class HornetQPropertyConversionException extends RuntimeException
{

   private static final long serialVersionUID = -3010008708334904332L;

   public HornetQPropertyConversionException(final String message)
   {
      super(message);
   }
}
