/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.hornetq.core.client.ClientMessage;
import org.hornetq.core.client.ClientSession;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.utils.ObjectInputStreamWithClassLoader;

public class HornetQObjectMessage
extends HornetQMessage
implements ObjectMessage {
    public static final byte TYPE = 2;
    private byte[] data;

    public HornetQObjectMessage() {
        super((byte)2);
    }

    public HornetQObjectMessage(ClientSession session) {
        super((byte)2, session);
    }

    public HornetQObjectMessage(ClientMessage message, ClientSession session) {
        super(message, session);
    }

    public HornetQObjectMessage(ObjectMessage foreign, ClientSession session) throws JMSException {
        super((Message)foreign, (byte)2, session);
        this.setObject(foreign.getObject());
    }

    public byte getType() {
        return 2;
    }

    public void doBeforeSend() throws Exception {
        this.getBody().clear();
        if (this.data != null) {
            this.getBody().writeInt(this.data.length);
            this.getBody().writeBytes(this.data);
        }
        super.doBeforeSend();
    }

    public void setObject(Serializable object) throws JMSException {
        this.checkWrite();
        if (object != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(object);
                oos.flush();
                this.data = baos.toByteArray();
            }
            catch (Exception e) {
                JMSException je = new JMSException("Failed to serialize object");
                je.setLinkedException(e);
                throw je;
            }
        }
    }

    public Serializable getObject() throws JMSException {
        if (this.data == null) {
            try {
                int len = this.getBody().readInt();
                this.data = new byte[len];
                this.getBody().readBytes(this.data);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (this.data.length == 0) {
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.data);
            ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader((InputStream)bais);
            Serializable object = (Serializable)ois.readObject();
            return object;
        }
        catch (Exception e) {
            JMSException je = new JMSException("Failed to deserialize object");
            je.setLinkedException(e);
            throw je;
        }
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.data = null;
    }
}

