/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.hornetq.core.client.ClientConsumer;
import org.hornetq.core.client.ClientMessage;
import org.hornetq.core.client.MessageHandler;
import org.hornetq.core.exception.HornetQException;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.HornetQDestination;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.jms.client.HornetQSession;
import org.hornetq.jms.client.JMSExceptionHelper;
import org.hornetq.jms.client.JMSMessageListenerWrapper;
import org.hornetq.utils.SimpleString;

public class HornetQMessageConsumer
implements MessageConsumer,
QueueReceiver,
TopicSubscriber {
    private static final Logger log = Logger.getLogger(HornetQMessageConsumer.class);
    private final ClientConsumer consumer;
    private MessageListener listener;
    private MessageHandler coreListener;
    private final HornetQSession session;
    private final int ackMode;
    private final boolean noLocal;
    private final HornetQDestination destination;
    private final String selector;
    private final SimpleString autoDeleteQueueName;

    protected HornetQMessageConsumer(HornetQSession session, ClientConsumer consumer, boolean noLocal, HornetQDestination destination, String selector, SimpleString autoDeleteQueueName) throws JMSException {
        this.session = session;
        this.consumer = consumer;
        this.ackMode = session.getAcknowledgeMode();
        this.noLocal = noLocal;
        this.destination = destination;
        this.selector = selector;
        this.autoDeleteQueueName = autoDeleteQueueName;
    }

    public String getMessageSelector() throws JMSException {
        this.checkClosed();
        return this.selector;
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return this.listener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.listener = listener;
        this.coreListener = listener == null ? null : new JMSMessageListenerWrapper(this.session, this.consumer, listener, this.ackMode);
        try {
            this.consumer.setMessageHandler(this.coreListener);
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    public Message receive() throws JMSException {
        return this.getMessage(0L);
    }

    public Message receive(long timeout) throws JMSException {
        return this.getMessage(timeout);
    }

    public Message receiveNoWait() throws JMSException {
        return this.getMessage(-1L);
    }

    public void close() throws JMSException {
        try {
            this.consumer.close();
            if (this.autoDeleteQueueName != null) {
                this.session.deleteQueue(this.autoDeleteQueueName);
            }
            this.session.removeConsumer(this);
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    public Queue getQueue() throws JMSException {
        return (Queue)this.destination;
    }

    public Topic getTopic() throws JMSException {
        return (Topic)this.destination;
    }

    public boolean getNoLocal() throws JMSException {
        return this.noLocal;
    }

    public String toString() {
        return "HornetQMessageConsumer[" + this.consumer + "]";
    }

    private void checkClosed() throws JMSException {
        if (this.session.getCoreSession().isClosed()) {
            throw new IllegalStateException("Consumer is closed");
        }
    }

    private HornetQMessage getMessage(long timeout) throws JMSException {
        try {
            ClientMessage message = this.consumer.receive(timeout);
            HornetQMessage msg = null;
            if (message != null) {
                message.acknowledge();
                msg = HornetQMessage.createMessage(message, this.ackMode == 2 ? this.session.getCoreSession() : null);
                try {
                    msg.doBeforeReceive();
                }
                catch (Exception e) {
                    log.error((Object)"Failed to prepare message for delivery", (Throwable)e);
                    return null;
                }
            }
            return msg;
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }
}

