/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.jms.management;

import org.hornetq.api.core.management.Operation;
import org.hornetq.api.core.management.Parameter;

public interface JMSServerControl {
    public boolean isStarted();

    public String getVersion();

    public String[] getTopicNames();

    public String[] getQueueNames();

    public String[] getConnectionFactoryNames();

    @Operation(desc="Create a JMS Queue", impact=1)
    public boolean createQueue(@Parameter(name="name", desc="Name of the queue to create") String var1) throws Exception;

    @Operation(desc="Create a JMS Queue", impact=1)
    public boolean createQueue(@Parameter(name="name", desc="Name of the queue to create") String var1, @Parameter(name="jndiBindings", desc="comma-separated list of JNDI bindings (use '&comma;' if u need to use commas in your jndi name)") String var2) throws Exception;

    @Operation(desc="Create a JMS Queue", impact=1)
    public boolean createQueue(@Parameter(name="name", desc="Name of the queue to create") String var1, @Parameter(name="jndiBindings", desc="comma-separated list of JNDI bindings (use '&comma;' if u need to use commas in your jndi name)") String var2, @Parameter(name="selector", desc="the jms selector") String var3) throws Exception;

    @Operation(desc="Create a JMS Queue", impact=1)
    public boolean createQueue(@Parameter(name="name", desc="Name of the queue to create") String var1, @Parameter(name="jndiBindings", desc="comma-separated list of JNDI bindings (use '&comma;' if u need to use commas in your jndi name)") String var2, @Parameter(name="selector", desc="the jms selector") String var3, @Parameter(name="durable", desc="durability of the queue") boolean var4) throws Exception;

    @Operation(desc="Destroy a JMS Queue", impact=1)
    public boolean destroyQueue(@Parameter(name="name", desc="Name of the queue to destroy") String var1) throws Exception;

    @Operation(desc="Create a JMS Topic", impact=1)
    public boolean createTopic(@Parameter(name="name", desc="Name of the topic to create") String var1) throws Exception;

    @Operation(desc="Create a JMS Topic", impact=1)
    public boolean createTopic(@Parameter(name="name", desc="Name of the topic to create") String var1, @Parameter(name="jndiBindings", desc="comma-separated list of JNDI bindings (use '&comma;' if u need to use commas in your jndi name)") String var2) throws Exception;

    @Operation(desc="Destroy a JMS Topic", impact=1)
    public boolean destroyTopic(@Parameter(name="name", desc="Name of the topic to destroy") String var1) throws Exception;

    public void createConnectionFactory(String var1, boolean var2, boolean var3, @Parameter(name="cfType", desc="RegularCF=0, QueueCF=1, TopicCF=2, XACF=3, QueueXACF=4, TopicXACF=5") int var4, String[] var5, Object[] var6) throws Exception;

    @Operation(desc="Create a JMS ConnectionFactory", impact=1)
    public void createConnectionFactory(@Parameter(name="name") String var1, @Parameter(name="ha") boolean var2, @Parameter(name="useDiscovery", desc="should we use discovery or a connector configuration") boolean var3, @Parameter(name="cfType", desc="RegularCF=0, QueueCF=1, TopicCF=2, XACF=3, QueueXACF=4, TopicXACF=5") int var4, @Parameter(name="connectorNames", desc="comma-separated list of connectorNames or the discovery group name") String var5, @Parameter(name="jndiBindings", desc="comma-separated list of JNDI bindings (use '&comma;' if u need to use commas in your jndi name)") String var6) throws Exception;

    @Operation(desc="Create a JMS ConnectionFactory", impact=1)
    public void createConnectionFactory(@Parameter(name="name") String var1, @Parameter(name="ha") boolean var2, @Parameter(name="useDiscovery", desc="should we use discovery or a connector configuration") boolean var3, @Parameter(name="cfType", desc="RegularCF=0, QueueCF=1, TopicCF=2, XACF=3, QueueXACF=4, TopicXACF=5") int var4, @Parameter(name="connectorNames", desc="An array of connector or the binding address") String[] var5, @Parameter(name="jndiBindings", desc="array JNDI bindings (use '&comma;' if u need to use commas in your jndi name)") String[] var6, @Parameter(name="clientID", desc="The clientID configured for the connectionFactory") String var7, @Parameter(name="clientFailureCheckPeriod", desc="clientFailureCheckPeriod") long var8, @Parameter(name="connectionTTL", desc="connectionTTL") long var10, @Parameter(name="callTimeout", desc="callTimeout") long var12, @Parameter(name="minLargeMessageSize", desc="minLargeMessageSize") int var14, @Parameter(name="compressLargeMessages", desc="compressLargeMessages") boolean var15, @Parameter(name="consumerWindowSize", desc="consumerWindowSize") int var16, @Parameter(name="consumerMaxRate", desc="consumerMaxRate") int var17, @Parameter(name="confirmationWindowSize", desc="confirmationWindowSize") int var18, @Parameter(name="producerWindowSize", desc="producerWindowSize") int var19, @Parameter(name="producerMaxRate", desc="producerMaxRate") int var20, @Parameter(name="blockOnAcknowledge", desc="blockOnAcknowledge") boolean var21, @Parameter(name="blockOnDurableSend", desc="blockOnDurableSend") boolean var22, @Parameter(name="blockOnNonDurableSend", desc="blockOnNonDurableSend") boolean var23, @Parameter(name="autoGroup", desc="autoGroup") boolean var24, @Parameter(name="preAcknowledge", desc="preAcknowledge") boolean var25, @Parameter(name="loadBalancingPolicyClassName", desc="loadBalancingPolicyClassName (null or blank mean use the default value)") String var26, @Parameter(name="transactionBatchSize", desc="transactionBatchSize") int var27, @Parameter(name="dupsOKBatchSize", desc="dupsOKBatchSize") int var28, @Parameter(name="useGlobalPools", desc="useGlobalPools") boolean var29, @Parameter(name="scheduledThreadPoolMaxSize", desc="scheduledThreadPoolMaxSize") int var30, @Parameter(name="threadPoolMaxSize", desc="threadPoolMaxSize") int var31, @Parameter(name="retryInterval", desc="retryInterval") long var32, @Parameter(name="retryIntervalMultiplier", desc="retryIntervalMultiplier") double var34, @Parameter(name="maxRetryInterval", desc="maxRetryInterval") long var36, @Parameter(name="reconnectAttempts", desc="reconnectAttempts") int var38, @Parameter(name="failoverOnInitialConnection", desc="failoverOnInitialConnection") boolean var39, @Parameter(name="groupId", desc="groupId") String var40) throws Exception;

    @Operation(desc="Create a JMS ConnectionFactory", impact=1)
    public void createConnectionFactory(@Parameter(name="name") String var1, @Parameter(name="ha") boolean var2, @Parameter(name="useDiscovery", desc="should we use discovery or a connector configuration") boolean var3, @Parameter(name="cfType", desc="RegularCF=0, QueueCF=1, TopicCF=2, XACF=3, QueueXACF=4, TopicXACF=5") int var4, @Parameter(name="connectorNames", desc="comma-separated list of connectorNames or the discovery group name") String var5, @Parameter(name="jndiBindings", desc="comma-separated list of JNDI bindings (use '&comma;' if u need to use commas in your jndi name)") String var6, @Parameter(name="clientID", desc="The clientID configured for the connectionFactory") String var7, @Parameter(name="clientFailureCheckPeriod", desc="clientFailureCheckPeriod") long var8, @Parameter(name="connectionTTL", desc="connectionTTL") long var10, @Parameter(name="callTimeout", desc="callTimeout") long var12, @Parameter(name="minLargeMessageSize", desc="minLargeMessageSize") int var14, @Parameter(name="compressLargeMessages", desc="compressLargeMessages") boolean var15, @Parameter(name="consumerWindowSize", desc="consumerWindowSize") int var16, @Parameter(name="consumerMaxRate", desc="consumerMaxRate") int var17, @Parameter(name="confirmationWindowSize", desc="confirmationWindowSize") int var18, @Parameter(name="producerWindowSize", desc="producerWindowSize") int var19, @Parameter(name="producerMaxRate", desc="producerMaxRate") int var20, @Parameter(name="blockOnAcknowledge", desc="blockOnAcknowledge") boolean var21, @Parameter(name="blockOnDurableSend", desc="blockOnDurableSend") boolean var22, @Parameter(name="blockOnNonDurableSend", desc="blockOnNonDurableSend") boolean var23, @Parameter(name="autoGroup", desc="autoGroup") boolean var24, @Parameter(name="preAcknowledge", desc="preAcknowledge") boolean var25, @Parameter(name="loadBalancingPolicyClassName", desc="loadBalancingPolicyClassName (null or blank mean use the default value)") String var26, @Parameter(name="transactionBatchSize", desc="transactionBatchSize") int var27, @Parameter(name="dupsOKBatchSize", desc="dupsOKBatchSize") int var28, @Parameter(name="useGlobalPools", desc="useGlobalPools") boolean var29, @Parameter(name="scheduledThreadPoolMaxSize", desc="scheduledThreadPoolMaxSize") int var30, @Parameter(name="threadPoolMaxSize", desc="threadPoolMaxSize") int var31, @Parameter(name="retryInterval", desc="retryInterval") long var32, @Parameter(name="retryIntervalMultiplier", desc="retryIntervalMultiplier") double var34, @Parameter(name="maxRetryInterval", desc="maxRetryInterval") long var36, @Parameter(name="reconnectAttempts", desc="reconnectAttempts") int var38, @Parameter(name="failoverOnInitialConnection", desc="failoverOnInitialConnection") boolean var39, @Parameter(name="groupId", desc="groupId") String var40) throws Exception;

    @Operation(desc="Destroy a JMS ConnectionFactory", impact=1)
    public void destroyConnectionFactory(@Parameter(name="name", desc="Name of the ConnectionFactory to destroy") String var1) throws Exception;

    @Operation(desc="List the client addresses", impact=0)
    public String[] listRemoteAddresses() throws Exception;

    @Operation(desc="List the client addresses which match the given IP Address", impact=0)
    public String[] listRemoteAddresses(@Parameter(desc="an IP address", name="ipAddress") String var1) throws Exception;

    @Operation(desc="Closes all the connections for the given IP Address", impact=0)
    public boolean closeConnectionsForAddress(@Parameter(desc="an IP address", name="ipAddress") String var1) throws Exception;

    @Operation(desc="List all the connection IDs", impact=0)
    public String[] listConnectionIDs() throws Exception;

    @Operation(desc="List all JMS connections")
    public String listConnectionsAsJSON() throws Exception;

    @Operation(desc="List the sessions for the given connectionID", impact=0)
    public String[] listSessions(@Parameter(desc="a connection ID", name="connectionID") String var1) throws Exception;

    @Operation(desc="List all JMS consumers associated to a JMS Connection")
    public String listConsumersAsJSON(@Parameter(desc="a connection ID", name="connectionID") String var1) throws Exception;

    @Operation(desc="List all JMS consumers associated to a JMS Connection")
    public String listAllConsumersAsJSON() throws Exception;

    @Operation(desc="Lists all addresses to which the designated session has sent messages", impact=0)
    public String[] listTargetDestinations(@Parameter(desc="a session ID", name="sessionID") String var1) throws Exception;

    @Operation(desc="Returns the last sent message's ID from the given session to an address", impact=0)
    public String getLastSentMessageID(@Parameter(desc="session name", name="sessionID") String var1, @Parameter(desc="address", name="address") String var2) throws Exception;

    @Operation(desc="Gets the sessions creation time", impact=0)
    public String getSessionCreationTime(@Parameter(desc="session name", name="sessionID") String var1) throws Exception;

    @Operation(desc="List the sessions for the given connectionID", impact=0)
    public String listSessionsAsJSON(@Parameter(desc="a connection ID", name="connectionID") String var1) throws Exception;

    @Operation(desc="List all the prepared transaction, sorted by date, oldest first, with details, in JSON format", impact=0)
    public String listPreparedTransactionDetailsAsJSON() throws Exception;

    @Operation(desc="List all the prepared transaction, sorted by date, oldest first, with details, in HTML format", impact=0)
    public String listPreparedTransactionDetailsAsHTML() throws Exception;
}

