/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.TopicConnection;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XATopicConnection;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.api.jms.JMSFactoryType;
import org.hornetq.jms.client.HornetQConnection;
import org.hornetq.jms.client.HornetQQueueConnection;
import org.hornetq.jms.client.HornetQTopicConnection;
import org.hornetq.jms.client.HornetQXAConnection;
import org.hornetq.jms.client.HornetQXAQueueConnection;
import org.hornetq.jms.client.HornetQXATopicConnection;
import org.hornetq.jms.referenceable.ConnectionFactoryObjectFactory;
import org.hornetq.jms.referenceable.SerializableObjectRefAddr;

public class HornetQConnectionFactory
implements Serializable,
Referenceable {
    private static final long serialVersionUID = -2810634789345348326L;
    private final ServerLocator serverLocator;
    private String clientID;
    private int dupsOKBatchSize = 0x100000;
    private int transactionBatchSize = 0x100000;
    private boolean readOnly;

    public HornetQConnectionFactory() {
        this.serverLocator = null;
    }

    public HornetQConnectionFactory(ServerLocator serverLocator) {
        this.serverLocator = serverLocator;
        serverLocator.disableFinalizeCheck();
    }

    public HornetQConnectionFactory(boolean ha, DiscoveryGroupConfiguration groupConfiguration) {
        this.serverLocator = ha ? HornetQClient.createServerLocatorWithHA((DiscoveryGroupConfiguration)groupConfiguration) : HornetQClient.createServerLocatorWithoutHA((DiscoveryGroupConfiguration)groupConfiguration);
        this.serverLocator.disableFinalizeCheck();
    }

    public HornetQConnectionFactory(boolean ha, TransportConfiguration ... initialConnectors) {
        this.serverLocator = ha ? HornetQClient.createServerLocatorWithHA((TransportConfiguration[])initialConnectors) : HornetQClient.createServerLocatorWithoutHA((TransportConfiguration[])initialConnectors);
        this.serverLocator.disableFinalizeCheck();
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    public Connection createConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, false, 0);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createQueueConnection(null, null);
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, false, 1);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.createTopicConnection(null, null);
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, false, 2);
    }

    public XAConnection createXAConnection() throws JMSException {
        return this.createXAConnection(null, null);
    }

    public XAConnection createXAConnection(String username, String password) throws JMSException {
        return (XAConnection)this.createConnectionInternal(username, password, true, 0);
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        return this.createXAQueueConnection(null, null);
    }

    public XAQueueConnection createXAQueueConnection(String username, String password) throws JMSException {
        return (XAQueueConnection)this.createConnectionInternal(username, password, true, 1);
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        return this.createXATopicConnection(null, null);
    }

    public XATopicConnection createXATopicConnection(String username, String password) throws JMSException {
        return (XATopicConnection)this.createConnectionInternal(username, password, true, 2);
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(this.getClass().getCanonicalName(), new SerializableObjectRefAddr("HornetQ-CF", this), ConnectionFactoryObjectFactory.class.getCanonicalName(), null);
    }

    public boolean isHA() {
        return this.serverLocator.isHA();
    }

    public synchronized String getConnectionLoadBalancingPolicyClassName() {
        return this.serverLocator.getConnectionLoadBalancingPolicyClassName();
    }

    public synchronized void setConnectionLoadBalancingPolicyClassName(String connectionLoadBalancingPolicyClassName) {
        this.checkWrite();
        this.serverLocator.setConnectionLoadBalancingPolicyClassName(connectionLoadBalancingPolicyClassName);
    }

    public synchronized TransportConfiguration[] getStaticConnectors() {
        return this.serverLocator.getStaticTransportConfigurations();
    }

    public synchronized DiscoveryGroupConfiguration getDiscoveryGroupConfiguration() {
        return this.serverLocator.getDiscoveryGroupConfiguration();
    }

    public synchronized String getClientID() {
        return this.clientID;
    }

    public synchronized void setClientID(String clientID) {
        this.checkWrite();
        this.clientID = clientID;
    }

    public synchronized int getDupsOKBatchSize() {
        return this.dupsOKBatchSize;
    }

    public synchronized void setDupsOKBatchSize(int dupsOKBatchSize) {
        this.checkWrite();
        this.dupsOKBatchSize = dupsOKBatchSize;
    }

    public synchronized int getTransactionBatchSize() {
        return this.transactionBatchSize;
    }

    public synchronized void setTransactionBatchSize(int transactionBatchSize) {
        this.checkWrite();
        this.transactionBatchSize = transactionBatchSize;
    }

    public synchronized long getClientFailureCheckPeriod() {
        return this.serverLocator.getClientFailureCheckPeriod();
    }

    public synchronized void setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.checkWrite();
        this.serverLocator.setClientFailureCheckPeriod(clientFailureCheckPeriod);
    }

    public synchronized long getConnectionTTL() {
        return this.serverLocator.getConnectionTTL();
    }

    public synchronized void setConnectionTTL(long connectionTTL) {
        this.checkWrite();
        this.serverLocator.setConnectionTTL(connectionTTL);
    }

    public synchronized long getCallTimeout() {
        return this.serverLocator.getCallTimeout();
    }

    public synchronized void setCallTimeout(long callTimeout) {
        this.checkWrite();
        this.serverLocator.setCallTimeout(callTimeout);
    }

    public synchronized long getCallFailoverTimeout() {
        return this.serverLocator.getCallFailoverTimeout();
    }

    public synchronized void setCallFailoverTimeout(long callTimeout) {
        this.checkWrite();
        this.serverLocator.setCallFailoverTimeout(callTimeout);
    }

    public synchronized int getConsumerWindowSize() {
        return this.serverLocator.getConsumerWindowSize();
    }

    public synchronized void setConsumerWindowSize(int consumerWindowSize) {
        this.checkWrite();
        this.serverLocator.setConsumerWindowSize(consumerWindowSize);
    }

    public synchronized int getConsumerMaxRate() {
        return this.serverLocator.getConsumerMaxRate();
    }

    public synchronized void setConsumerMaxRate(int consumerMaxRate) {
        this.checkWrite();
        this.serverLocator.setConsumerMaxRate(consumerMaxRate);
    }

    public synchronized int getConfirmationWindowSize() {
        return this.serverLocator.getConfirmationWindowSize();
    }

    public synchronized void setConfirmationWindowSize(int confirmationWindowSize) {
        this.checkWrite();
        this.serverLocator.setConfirmationWindowSize(confirmationWindowSize);
    }

    public synchronized int getProducerMaxRate() {
        return this.serverLocator.getProducerMaxRate();
    }

    public synchronized void setProducerMaxRate(int producerMaxRate) {
        this.checkWrite();
        this.serverLocator.setProducerMaxRate(producerMaxRate);
    }

    public synchronized int getProducerWindowSize() {
        return this.serverLocator.getProducerWindowSize();
    }

    public synchronized void setProducerWindowSize(int producerWindowSize) {
        this.checkWrite();
        this.serverLocator.setProducerWindowSize(producerWindowSize);
    }

    public synchronized void setCacheLargeMessagesClient(boolean cacheLargeMessagesClient) {
        this.checkWrite();
        this.serverLocator.setCacheLargeMessagesClient(cacheLargeMessagesClient);
    }

    public synchronized boolean isCacheLargeMessagesClient() {
        return this.serverLocator.isCacheLargeMessagesClient();
    }

    public synchronized int getMinLargeMessageSize() {
        return this.serverLocator.getMinLargeMessageSize();
    }

    public synchronized void setMinLargeMessageSize(int minLargeMessageSize) {
        this.checkWrite();
        this.serverLocator.setMinLargeMessageSize(minLargeMessageSize);
    }

    public synchronized boolean isBlockOnAcknowledge() {
        return this.serverLocator.isBlockOnAcknowledge();
    }

    public synchronized void setBlockOnAcknowledge(boolean blockOnAcknowledge) {
        this.checkWrite();
        this.serverLocator.setBlockOnAcknowledge(blockOnAcknowledge);
    }

    public synchronized boolean isBlockOnNonDurableSend() {
        return this.serverLocator.isBlockOnNonDurableSend();
    }

    public synchronized void setBlockOnNonDurableSend(boolean blockOnNonDurableSend) {
        this.checkWrite();
        this.serverLocator.setBlockOnNonDurableSend(blockOnNonDurableSend);
    }

    public synchronized boolean isBlockOnDurableSend() {
        return this.serverLocator.isBlockOnDurableSend();
    }

    public synchronized void setBlockOnDurableSend(boolean blockOnDurableSend) {
        this.checkWrite();
        this.serverLocator.setBlockOnDurableSend(blockOnDurableSend);
    }

    public synchronized boolean isAutoGroup() {
        return this.serverLocator.isAutoGroup();
    }

    public synchronized void setAutoGroup(boolean autoGroup) {
        this.checkWrite();
        this.serverLocator.setAutoGroup(autoGroup);
    }

    public synchronized boolean isPreAcknowledge() {
        return this.serverLocator.isPreAcknowledge();
    }

    public synchronized void setPreAcknowledge(boolean preAcknowledge) {
        this.checkWrite();
        this.serverLocator.setPreAcknowledge(preAcknowledge);
    }

    public synchronized long getRetryInterval() {
        return this.serverLocator.getRetryInterval();
    }

    public synchronized void setRetryInterval(long retryInterval) {
        this.checkWrite();
        this.serverLocator.setRetryInterval(retryInterval);
    }

    public synchronized long getMaxRetryInterval() {
        return this.serverLocator.getMaxRetryInterval();
    }

    public synchronized void setMaxRetryInterval(long retryInterval) {
        this.checkWrite();
        this.serverLocator.setMaxRetryInterval(retryInterval);
    }

    public synchronized double getRetryIntervalMultiplier() {
        return this.serverLocator.getRetryIntervalMultiplier();
    }

    public synchronized void setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.checkWrite();
        this.serverLocator.setRetryIntervalMultiplier(retryIntervalMultiplier);
    }

    public synchronized int getReconnectAttempts() {
        return this.serverLocator.getReconnectAttempts();
    }

    public synchronized void setReconnectAttempts(int reconnectAttempts) {
        this.checkWrite();
        this.serverLocator.setReconnectAttempts(reconnectAttempts);
    }

    public synchronized void setInitialConnectAttempts(int reconnectAttempts) {
        this.checkWrite();
        this.serverLocator.setInitialConnectAttempts(reconnectAttempts);
    }

    public synchronized int getInitialConnectAttempts() {
        this.checkWrite();
        return this.serverLocator.getInitialConnectAttempts();
    }

    public synchronized boolean isFailoverOnInitialConnection() {
        return this.serverLocator.isFailoverOnInitialConnection();
    }

    public synchronized void setFailoverOnInitialConnection(boolean failover) {
        this.checkWrite();
        this.serverLocator.setFailoverOnInitialConnection(failover);
    }

    public synchronized boolean isUseGlobalPools() {
        return this.serverLocator.isUseGlobalPools();
    }

    public synchronized void setUseGlobalPools(boolean useGlobalPools) {
        this.checkWrite();
        this.serverLocator.setUseGlobalPools(useGlobalPools);
    }

    public synchronized int getScheduledThreadPoolMaxSize() {
        return this.serverLocator.getScheduledThreadPoolMaxSize();
    }

    public synchronized void setScheduledThreadPoolMaxSize(int scheduledThreadPoolMaxSize) {
        this.checkWrite();
        this.serverLocator.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
    }

    public synchronized int getThreadPoolMaxSize() {
        return this.serverLocator.getThreadPoolMaxSize();
    }

    public synchronized void setThreadPoolMaxSize(int threadPoolMaxSize) {
        this.checkWrite();
        this.serverLocator.setThreadPoolMaxSize(threadPoolMaxSize);
    }

    public synchronized int getInitialMessagePacketSize() {
        return this.serverLocator.getInitialMessagePacketSize();
    }

    public synchronized void setInitialMessagePacketSize(int size) {
        this.checkWrite();
        this.serverLocator.setInitialMessagePacketSize(size);
    }

    public void setGroupID(String groupID) {
        this.serverLocator.setGroupID(groupID);
    }

    public String getGroupID() {
        return this.serverLocator.getGroupID();
    }

    public boolean isCompressLargeMessage() {
        return this.serverLocator.isCompressLargeMessage();
    }

    public void setCompressLargeMessage(boolean compress) {
        this.serverLocator.setCompressLargeMessage(compress);
    }

    public void close() {
        ServerLocator locator0 = this.serverLocator;
        if (locator0 != null) {
            locator0.close();
        }
    }

    public ServerLocator getServerLocator() {
        return this.serverLocator;
    }

    public int getFactoryType() {
        return JMSFactoryType.CF.intValue();
    }

    protected synchronized HornetQConnection createConnectionInternal(String username, String password, boolean isXA, int type) throws JMSException {
        ClientSessionFactory factory;
        this.readOnly = true;
        try {
            factory = this.serverLocator.createSessionFactory();
        }
        catch (Exception e) {
            JMSException jmse = new JMSException("Failed to create session factory");
            jmse.initCause((Throwable)e);
            jmse.setLinkedException(e);
            throw jmse;
        }
        HornetQConnection connection = null;
        if (isXA) {
            if (type == 0) {
                connection = new HornetQXAConnection(username, password, type, this.clientID, this.dupsOKBatchSize, this.transactionBatchSize, factory);
            } else if (type == 1) {
                connection = new HornetQXAQueueConnection(username, password, type, this.clientID, this.dupsOKBatchSize, this.transactionBatchSize, factory);
            } else if (type == 2) {
                connection = new HornetQXATopicConnection(username, password, type, this.clientID, this.dupsOKBatchSize, this.transactionBatchSize, factory);
            }
        } else if (type == 0) {
            connection = new HornetQConnection(username, password, type, this.clientID, this.dupsOKBatchSize, this.transactionBatchSize, factory);
        } else if (type == 1) {
            connection = new HornetQQueueConnection(username, password, type, this.clientID, this.dupsOKBatchSize, this.transactionBatchSize, factory);
        } else if (type == 2) {
            connection = new HornetQTopicConnection(username, password, type, this.clientID, this.dupsOKBatchSize, this.transactionBatchSize, factory);
        }
        if (connection == null) {
            throw new JMSException("Failed to create connection: invalid type " + type);
        }
        connection.setReference(this);
        try {
            connection.authorize();
        }
        catch (JMSException e) {
            try {
                connection.close();
            }
            catch (JMSException me) {
                // empty catch block
            }
            throw e;
        }
        return connection;
    }

    public String toString() {
        return "HornetQConnectionFactory [serverLocator=" + this.serverLocator + ", clientID=" + this.clientID + ", dupsOKBatchSize=" + this.dupsOKBatchSize + ", transactionBatchSize=" + this.transactionBatchSize + ", readOnly=" + this.readOnly + "]";
    }

    private void checkWrite() {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set attribute on HornetQConnectionFactory after it has been used");
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.serverLocator.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.finalize();
    }
}

