/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQPropertyConversionException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.utils.TypedProperties;

public final class HornetQMapMessage
extends HornetQMessage
implements MapMessage {
    public static final byte TYPE = 5;
    private TypedProperties map = new TypedProperties();
    private boolean invalid;

    protected HornetQMapMessage(ClientSession session) {
        super((byte)5, session);
        this.map = new TypedProperties();
        this.invalid = true;
    }

    protected HornetQMapMessage(ClientMessage message, ClientSession session) {
        super(message, session);
        this.invalid = false;
    }

    public HornetQMapMessage() {
        this.invalid = false;
    }

    public HornetQMapMessage(MapMessage foreign, ClientSession session) throws JMSException {
        super((Message)foreign, (byte)5, session);
        Enumeration names = foreign.getMapNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object obj = foreign.getObject(name);
            this.setObject(name, obj);
        }
    }

    @Override
    public byte getType() {
        return 5;
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        this.checkName(name);
        this.map.putBooleanProperty(new SimpleString(name), value);
        this.invalid = true;
    }

    public void setByte(String name, byte value) throws JMSException {
        this.checkName(name);
        this.map.putByteProperty(new SimpleString(name), value);
        this.invalid = true;
    }

    public void setShort(String name, short value) throws JMSException {
        this.checkName(name);
        this.map.putShortProperty(new SimpleString(name), value);
        this.invalid = true;
    }

    public void setChar(String name, char value) throws JMSException {
        this.checkName(name);
        this.map.putCharProperty(new SimpleString(name), value);
        this.invalid = true;
    }

    public void setInt(String name, int value) throws JMSException {
        this.checkName(name);
        this.map.putIntProperty(new SimpleString(name), value);
        this.invalid = true;
    }

    public void setLong(String name, long value) throws JMSException {
        this.checkName(name);
        this.map.putLongProperty(new SimpleString(name), value);
        this.invalid = true;
    }

    public void setFloat(String name, float value) throws JMSException {
        this.checkName(name);
        this.map.putFloatProperty(new SimpleString(name), value);
        this.invalid = true;
    }

    public void setDouble(String name, double value) throws JMSException {
        this.checkName(name);
        this.map.putDoubleProperty(new SimpleString(name), value);
        this.invalid = true;
    }

    public void setString(String name, String value) throws JMSException {
        this.checkName(name);
        this.map.putSimpleStringProperty(new SimpleString(name), value == null ? null : new SimpleString(value));
        this.invalid = true;
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        this.checkName(name);
        this.map.putBytesProperty(new SimpleString(name), value);
        this.invalid = true;
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        this.checkName(name);
        if (offset + length > value.length) {
            throw new JMSException("Invalid offset/length");
        }
        byte[] newBytes = new byte[length];
        System.arraycopy(value, offset, newBytes, 0, length);
        this.map.putBytesProperty(new SimpleString(name), newBytes);
        this.invalid = true;
    }

    public void setObject(String name, Object value) throws JMSException {
        this.checkName(name);
        try {
            TypedProperties.setObjectProperty((SimpleString)new SimpleString(name), (Object)value, (TypedProperties)this.map);
        }
        catch (HornetQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
        this.invalid = true;
    }

    public boolean getBoolean(String name) throws JMSException {
        try {
            return this.map.getBooleanProperty(new SimpleString(name));
        }
        catch (HornetQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public byte getByte(String name) throws JMSException {
        try {
            return this.map.getByteProperty(new SimpleString(name));
        }
        catch (HornetQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public short getShort(String name) throws JMSException {
        try {
            return this.map.getShortProperty(new SimpleString(name));
        }
        catch (HornetQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public char getChar(String name) throws JMSException {
        try {
            return this.map.getCharProperty(new SimpleString(name)).charValue();
        }
        catch (HornetQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public int getInt(String name) throws JMSException {
        try {
            return this.map.getIntProperty(new SimpleString(name));
        }
        catch (HornetQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public long getLong(String name) throws JMSException {
        try {
            return this.map.getLongProperty(new SimpleString(name));
        }
        catch (HornetQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public float getFloat(String name) throws JMSException {
        try {
            return this.map.getFloatProperty(new SimpleString(name)).floatValue();
        }
        catch (HornetQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public double getDouble(String name) throws JMSException {
        try {
            return this.map.getDoubleProperty(new SimpleString(name));
        }
        catch (HornetQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public String getString(String name) throws JMSException {
        try {
            SimpleString str = this.map.getSimpleStringProperty(new SimpleString(name));
            if (str == null) {
                return null;
            }
            return str.toString();
        }
        catch (HornetQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public byte[] getBytes(String name) throws JMSException {
        try {
            return this.map.getBytesProperty(new SimpleString(name));
        }
        catch (HornetQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public Object getObject(String name) throws JMSException {
        Object val = this.map.getProperty(new SimpleString(name));
        if (val instanceof SimpleString) {
            val = ((SimpleString)val).toString();
        }
        return val;
    }

    public Enumeration getMapNames() throws JMSException {
        HashSet<String> propNames = new HashSet<String>();
        for (SimpleString str : this.map.getPropertyNames()) {
            propNames.add(str.toString());
        }
        return Collections.enumeration(propNames);
    }

    public boolean itemExists(String name) throws JMSException {
        return this.map.containsProperty(new SimpleString(name));
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.map.clear();
        this.invalid = true;
    }

    @Override
    public void doBeforeSend() throws Exception {
        if (this.invalid) {
            this.message.getBodyBuffer().resetWriterIndex();
            this.map.encode(this.message.getBodyBuffer());
            this.invalid = false;
        }
        super.doBeforeSend();
    }

    @Override
    public void doBeforeReceive() throws HornetQException {
        super.doBeforeReceive();
        this.map.decode(this.message.getBodyBuffer());
    }

    private void checkName(String name) throws JMSException {
        this.checkWrite();
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null.");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("Name must not be an empty String.");
        }
    }
}

