/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.persistence.config;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.jms.persistence.config.PersistedType;
import org.hornetq.utils.BufferHelper;

public class PersistedDestination
implements EncodingSupport {
    private long id;
    private PersistedType type;
    private String name;
    private String selector;
    private boolean durable;

    public PersistedDestination() {
    }

    public PersistedDestination(PersistedType type, String name) {
        this(type, name, null, true);
    }

    public PersistedDestination(PersistedType type, String name, String selector, boolean durable) {
        this.type = type;
        this.name = name;
        this.selector = selector;
        this.durable = durable;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public PersistedType getType() {
        return this.type;
    }

    public String getSelector() {
        return this.selector;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public int getEncodeSize() {
        return 1 + BufferHelper.sizeOfSimpleString((String)this.name) + BufferHelper.sizeOfNullableSimpleString((String)this.selector) + 1;
    }

    public void encode(HornetQBuffer buffer) {
        buffer.writeByte(this.type.getType());
        buffer.writeSimpleString(SimpleString.toSimpleString((String)this.name));
        buffer.writeNullableSimpleString(SimpleString.toSimpleString((String)this.selector));
        buffer.writeBoolean(this.durable);
    }

    public void decode(HornetQBuffer buffer) {
        this.type = PersistedType.getType(buffer.readByte());
        this.name = buffer.readSimpleString().toString();
        SimpleString selectorStr = buffer.readNullableSimpleString();
        this.selector = selectorStr == null ? null : selectorStr.toString();
        this.durable = buffer.readBoolean();
    }
}

