/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.transaction;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.TransactionDetail;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.utils.ObjectInputStreamWithClassLoader;
import org.hornetq.utils.TypedProperties;

public class JMSTransactionDetail
extends TransactionDetail {
    public JMSTransactionDetail(Xid xid, Transaction tx, Long creation) throws Exception {
        super(xid, tx, creation);
    }

    public String decodeMessageType(ServerMessage msg) {
        byte type = msg.getType();
        switch (type) {
            case 0: {
                return "Default";
            }
            case 2: {
                return "ObjectMessage";
            }
            case 3: {
                return "TextMessage";
            }
            case 4: {
                return "ByteMessage";
            }
            case 5: {
                return "MapMessage";
            }
            case 6: {
                return "StreamMessage";
            }
        }
        return "(Unknown Type)";
    }

    public String decodeMessagePayload(ServerMessage msg) {
        byte type = msg.getType();
        HornetQBuffer bodyBuffer = msg.getBodyBuffer();
        try {
            switch (type) {
                case 2: {
                    int len = bodyBuffer.readInt();
                    byte[] data = new byte[len];
                    bodyBuffer.readBytes(data);
                    ByteArrayInputStream bais = new ByteArrayInputStream(data);
                    ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader((InputStream)bais);
                    Serializable object = (Serializable)ois.readObject();
                    return object.toString();
                }
                case 3: {
                    return bodyBuffer.readNullableSimpleString().toString();
                }
                case 5: {
                    TypedProperties pmap = new TypedProperties();
                    pmap.decode(msg.getBodyBuffer());
                    return pmap.toString();
                }
            }
            return "(Not Available)";
        }
        catch (Throwable t) {
            return "(Not Available)";
        }
    }

    public Map<String, Object> decodeMessageProperties(ServerMessage msg) {
        try {
            return HornetQMessage.coreMaptoJMSMap(msg.toMap());
        }
        catch (Throwable t) {
            return null;
        }
    }
}

